/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.FluidizerPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.network.UpdateFluidizerFluidStatus;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType2;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelDataCache;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class AbstractFluidizerEntity
extends AbstractMultiblockEntity<MultiblockFluidizer>
implements IMultiblockPartTypeProvider<MultiblockFluidizer, FluidizerPartType> {
    private static final CuboidPartVariantsModelDataCache s_modelDataCaches = new CuboidPartVariantsModelDataCache();

    public AbstractFluidizerEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    protected boolean isFluidizerActive() {
        return this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).map(MultiblockFluidizer::isMachineActive).orElse(false);
    }

    protected void setFluidizerActive(boolean active) {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(c -> c.setMachineActive(active));
    }

    protected void onIngredientsChanged(IStackHolder.ChangeType changeType) {
        this.executeOnController(controller -> controller.onIngredientsChanged(changeType));
    }

    public IFluidHandler getFluidOutput() {
        return (IFluidHandler)this.evalOnController(MultiblockFluidizer::getFluidHandler, FluidHelper.EMPTY_FLUID_HANDLER);
    }

    public Component getPartDisplayName() {
        return Component.translatable((String)this.getPartType().map(IMultiblockPartType2::getTranslationKey).orElse("unknown"));
    }

    protected ModelData getUpdatedModelData() {
        return this.getPartType().map(this::getUpdatedModelData).orElse(ModelData.EMPTY);
    }

    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public void onUpdateFluidStatus(UpdateFluidizerFluidStatus message) {
        this.executeOnController(c -> c.onUpdateFluidStatus(message));
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.addUnlocalized("Model Variant Index: %d", new Object[]{this.getUpdatedModelVariantIndex()});
    }

    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFrame()) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.fluidizer.invalid_frame_block", new Object[0]);
            return false;
        }
        if (PartPosition.Interior == position) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.fluidizer.invalid_part_for_interior", new Object[0]);
            return false;
        }
        return true;
    }

    public MultiblockFluidizer createController() {
        return new MultiblockFluidizer(Objects.requireNonNull(this.getLevel(), "Trying to create a Controller from a Part without a Level"));
    }

    public Class<MultiblockFluidizer> getControllerType() {
        return MultiblockFluidizer.class;
    }

    public void onMachineActivated() {
    }

    public void onMachineDeactivated() {
    }

    protected ModelData getUpdatedModelData(FluidizerPartType partType) {
        return s_modelDataCaches.computeIfAbsent(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings());
    }
}

