/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipe;

import it.zerono.mods.extremereactors.datagen.recipe.AbstractRecipesDataProvider;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.OneToOneRecipeBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.TwoToOneRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidizerRecipesDataProvider
extends AbstractRecipesDataProvider {
    public FluidizerRecipesDataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot) {
        super("bigreactors", "Fluidizer recipes", output, registryLookup, modLocationRoot);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.solid(output, "yellorium", Content.Items.YELLORIUM_INGOT, Content.Fluids.YELLORIUM_SOURCE);
        this.solid(output, "yellorium9", Content.Items.YELLORIUM_BLOCK, Content.Fluids.YELLORIUM_SOURCE, 9);
        this.solid(output, "cyanite", Content.Items.CYANITE_INGOT, Content.Fluids.CYANITE_SOURCE);
        this.solid(output, "cyanite9", Content.Items.CYANITE_BLOCK, Content.Fluids.CYANITE_SOURCE, 9);
        this.solid(output, "blutonium", Content.Items.BLUTONIUM_INGOT, Content.Fluids.BLUTONIUM_SOURCE);
        this.solid(output, "blutonium9", Content.Items.BLUTONIUM_BLOCK, Content.Fluids.BLUTONIUM_SOURCE, 9);
        this.solid(output, "magentite", Content.Items.MAGENTITE_INGOT, Content.Fluids.MAGENTITE_SOURCE);
        this.solid(output, "magentite9", Content.Items.MAGENTITE_BLOCK, Content.Fluids.MAGENTITE_SOURCE, 9);
        this.solidMixing(output, "verderium", Content.Items.YELLORIUM_INGOT, 2, Content.Items.BLUTONIUM_INGOT, 1, Content.Fluids.VERDERIUM_SOURCE, 2);
        this.solidMixing(output, "verderium9", Content.Items.YELLORIUM_BLOCK, 2, Content.Items.BLUTONIUM_BLOCK, 1, Content.Fluids.VERDERIUM_SOURCE, 18);
        this.fluidMixing(output, "verderium", Content.Fluids.YELLORIUM_SOURCE, 2000, Content.Fluids.BLUTONIUM_SOURCE, 1000, Content.Fluids.VERDERIUM_SOURCE, 2000);
        this.solidMixing(output, "cryomisi", Items.REDSTONE, 1, Items.SNOW_BLOCK, 1, (Fluid)Content.Fluids.CRYOMISI_SOURCE.get(), 500);
        this.solidMixing(output, "tangerium", (Item)Content.Items.ANGLESITE_CRYSTAL.get(), 1, Items.ENDER_PEARL, 4, (Fluid)Content.Fluids.TANGERIUM_SOURCE.get(), 500);
        this.fluidMixing(output, "redfrigium", Content.Fluids.CRYOMISI_SOURCE, 1000, Content.Fluids.TANGERIUM_SOURCE, 1000, Content.Fluids.REDFRIGIUM_SOURCE, 2000);
        this.casing(output);
        this.glass(output);
        this.controller(output);
        this.port(output, "solidinjector", Content.Items.FLUIDIZER_SOLIDINJECTOR, (ItemLike)Items.STICKY_PISTON, ContentTags.Items.INGOTS_YELLORIUM, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE);
        this.port(output, "fluidinjector", Content.Items.FLUIDIZER_FLUIDINJECTOR, (ItemLike)Items.PISTON, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, (TagKey<Item>)Tags.Items.GEMS_LAPIS);
        this.port(output, "outputport", Content.Items.FLUIDIZER_OUTPUTPORT, (ItemLike)Items.DISPENSER, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, (TagKey<Item>)Tags.Items.CHESTS);
        this.port(output, "powerport", Content.Items.FLUIDIZER_POWERPORT, (ItemLike)Items.REPEATER, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
    }

    private void solid(RecipeOutput output, String name, Supplier<? extends Item> ingredient, Supplier<FlowingFluid> result) {
        this.solid(output, name, ingredient, result, 1);
    }

    private void solid(RecipeOutput output, String name, Supplier<? extends Item> ingredient, Supplier<FlowingFluid> result, int resultMultiplier) {
        this.solid(output, name, ingredient.get(), 1, (Fluid)result.get(), 1000 * resultMultiplier);
    }

    private void solid(RecipeOutput output, String name, Item ingredient, int ingredientAmount, Fluid result, int resultAmount) {
        new OneToOneRecipeBuilder((IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient, (int)ingredientAmount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerSolidRecipe::new).build(output, this.fluidizerSolidRoot().buildWithSuffix(name));
    }

    private void solidMixing(RecipeOutput output, String name, Supplier<? extends Item> ingredient1, int ingredient1Amount, Supplier<? extends Item> ingredient2, int ingredient2Amount, Supplier<FlowingFluid> result, int resultMultiplier) {
        this.solidMixing(output, name, ingredient1.get(), ingredient1Amount, ingredient2.get(), ingredient2Amount, (Fluid)result.get(), 1000 * resultMultiplier);
    }

    private void solidMixing(RecipeOutput output, String name, Item ingredient1, int ingredient1Amount, Item ingredient2, int ingredient2Amount, Fluid result, int resultAmount) {
        ResourceLocationBuilder idBuilder = this.fluidizerSolidMixingRoot().append(name);
        new TwoToOneRecipeBuilder((IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient1, (int)ingredient1Amount), (IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient2, (int)ingredient2Amount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerSolidMixingRecipe::new).build(output, idBuilder.buildWithSuffix("_1"));
        new TwoToOneRecipeBuilder((IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient2, (int)ingredient2Amount), (IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient1, (int)ingredient1Amount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerSolidMixingRecipe::new).build(output, idBuilder.buildWithSuffix("_2"));
    }

    private void fluidMixing(RecipeOutput output, String name, Supplier<? extends Fluid> ingredient1, int ingredient1Amount, Supplier<? extends Fluid> ingredient2, int ingredient2Amount, Supplier<? extends Fluid> result, int resultAmount) {
        this.fluidMixing(output, name, ingredient1.get(), ingredient1Amount, ingredient2.get(), ingredient2Amount, result.get(), resultAmount);
    }

    private void fluidMixing(RecipeOutput output, String name, Fluid ingredient1, int ingredient1Amount, Fluid ingredient2, int ingredient2Amount, Fluid result, int resultAmount) {
        ResourceLocationBuilder idBuilder = this.fluidizerFluidMixingRoot().append(name);
        new TwoToOneRecipeBuilder((IRecipeIngredient)FluidStackRecipeIngredient.from((Fluid)ingredient1, (int)ingredient1Amount), (IRecipeIngredient)FluidStackRecipeIngredient.from((Fluid)ingredient2, (int)ingredient2Amount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerFluidMixingRecipe::new).build(output, idBuilder.buildWithSuffix("_1"));
        new TwoToOneRecipeBuilder((IRecipeIngredient)FluidStackRecipeIngredient.from((Fluid)ingredient2, (int)ingredient2Amount), (IRecipeIngredient)FluidStackRecipeIngredient.from((Fluid)ingredient1, (int)ingredient1Amount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerFluidMixingRecipe::new).build(output, idBuilder.buildWithSuffix("_2"));
    }

    private void casing(RecipeOutput output) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Content.Items.FLUIDIZER_CASING).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('W'), (ItemLike)Items.WATER_BUCKET).define(Character.valueOf('C'), ContentTags.Items.INGOTS_YELLORIUM).pattern("ICI").pattern("CWC").pattern("ICI").unlockedBy("has_item", FluidizerRecipesDataProvider.has(ContentTags.Items.INGOTS_YELLORIUM)).save(output, this.fluidizerRoot().buildWithSuffix("casing"));
    }

    private void glass(RecipeOutput output) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Content.Items.FLUIDIZER_GLASS).define(Character.valueOf('C'), (ItemLike)Content.Items.FLUIDIZER_CASING.get()).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).pattern("GCG").unlockedBy("has_item", FluidizerRecipesDataProvider.has((ItemLike)((ItemLike)Content.Items.FLUIDIZER_CASING.get()))).save(output, this.fluidizerRoot().buildWithSuffix("glass"));
    }

    private void controller(RecipeOutput output) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, Content.Items.FLUIDIZER_CONTROLLER).define(Character.valueOf('C'), (ItemLike)Content.Items.FLUIDIZER_CASING.get()).define(Character.valueOf('Y'), ContentTags.Items.INGOTS_YELLORIUM).define(Character.valueOf('P'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('E'), Tags.Items.GEMS_EMERALD).define(Character.valueOf('X'), (ItemLike)Items.COMPARATOR).pattern("CXC").pattern("YEY").pattern("CPC").unlockedBy("has_item", FluidizerRecipesDataProvider.has((ItemLike)((ItemLike)Content.Items.FLUIDIZER_CASING.get()))).unlockedBy("has_item2", FluidizerRecipesDataProvider.has((TagKey)Tags.Items.DUSTS_GLOWSTONE)).save(output, this.fluidizerRoot().buildWithSuffix("controller"));
    }

    private void port(RecipeOutput output, String name, Supplier<? extends ItemLike> result, ItemLike item1, TagKey<Item> tag2, TagKey<Item> tag3) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('C'), (ItemLike)Content.Items.FLUIDIZER_CASING.get()).define(Character.valueOf('1'), item1).define(Character.valueOf('2'), tag2).define(Character.valueOf('3'), tag3).pattern("C2C").pattern("313").pattern("C2C").unlockedBy("has_item", FluidizerRecipesDataProvider.has((ItemLike)((ItemLike)Content.Items.FLUIDIZER_CASING.get()))).unlockedBy("has_item2", FluidizerRecipesDataProvider.has((ItemLike)item1)).save(output, this.fluidizerRoot().buildWithSuffix(name));
    }
}

