/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.common.base.Predicates;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.Level;

public class CommonTooltipUtil {
    public static void appendBossData(Level level, LivingEntity entity, Consumer<Component> tooltip) {
        DynamicHolder rarity = RarityRegistry.INSTANCE.holder(ResourceLocation.tryParse((String)entity.getPersistentData().getString("apoth.boss.rarity")));
        if (!rarity.isBound()) {
            return;
        }
        tooltip.accept((Component)Component.translatable((String)"info.apotheosis.boss", (Object[])new Object[]{((LootRarity)rarity.get()).toComponent()}).withStyle(ChatFormatting.GRAY));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            tooltip.accept(CommonComponents.EMPTY);
            tooltip.accept((Component)Component.translatable((String)"info.apotheosis.boss_modifiers").withStyle(ChatFormatting.GRAY));
            AttributeMap map = entity.getAttributes();
            BuiltInRegistries.ATTRIBUTE.holders().map(arg_0 -> ((AttributeMap)map).getInstance(arg_0)).filter((Predicate<AttributeInstance>)Predicates.notNull()).forEach(inst -> {
                for (AttributeModifier modif : inst.getModifiers()) {
                    if (!modif.id().getPath().startsWith("apothic_invader_")) continue;
                    tooltip.accept((Component)((Attribute)inst.getAttribute().value()).toComponent(modif, ApothicAttributes.getTooltipFlag()));
                }
            });
        }
    }
}

