/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.cutting;

import dev.shadowsoffire.apotheosis.Apoth;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.spongepowered.include.com.google.common.base.Preconditions;

public interface GemCuttingRecipe
extends Recipe<CuttingRecipeInput> {
    public void decrementInputs(CuttingRecipeInput var1, Level var2);

    public boolean isValidBaseItem(CuttingRecipeInput var1, ItemStack var2);

    public boolean isValidTopItem(CuttingRecipeInput var1, ItemStack var2);

    public boolean isValidLeftItem(CuttingRecipeInput var1, ItemStack var2);

    public boolean isValidRightItem(CuttingRecipeInput var1, ItemStack var2);

    default public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    default public RecipeType<?> getType() {
        return Apoth.RecipeTypes.GEM_CUTTING;
    }

    @Nullable
    public static SizedIngredient getMatch(ItemStack stack, List<SizedIngredient> ingredients) {
        for (SizedIngredient si : ingredients) {
            if (!si.test(stack)) continue;
            return si;
        }
        return null;
    }

    public static SizedIngredient getMatchOrThrow(ItemStack stack, List<SizedIngredient> ingredients) {
        return (SizedIngredient)Preconditions.checkNotNull((Object)GemCuttingRecipe.getMatch(stack, ingredients), (Object)("Failed to find a match for " + String.valueOf(stack)));
    }

    public static boolean anyMatch(ItemStack stack, List<SizedIngredient> ingredients) {
        return GemCuttingRecipe.getMatch(stack, ingredients) != null;
    }

    public static class CuttingRecipeInput
    extends RecipeWrapper {
        public CuttingRecipeInput(IItemHandler inv) {
            super(inv);
        }

        public ItemStack getBase() {
            return this.getItem(0);
        }

        public ItemStack getTop() {
            return this.getItem(1);
        }

        public ItemStack getLeft() {
            return this.getItem(2);
        }

        public ItemStack getRight() {
            return this.getItem(3);
        }
    }
}

