/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.data;

import dev.shadowsoffire.apotheosis.Apotheosis;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class ApothPaintingsProvider {
    public static final ResourceKey<PaintingVariant> CRAIG = ApothPaintingsProvider.create("craig");
    public static final ResourceKey<PaintingVariant> ENCHANTING_TABLE = ApothPaintingsProvider.create("enchanting_table");
    public static final ResourceKey<PaintingVariant> GEMS = ApothPaintingsProvider.create("gems");
    public static final ResourceKey<PaintingVariant> TOWER = ApothPaintingsProvider.create("tower");
    public static final ResourceKey<PaintingVariant> WINDOW = ApothPaintingsProvider.create("window");

    public static void bootstrap(BootstrapContext<PaintingVariant> ctx) {
        ApothPaintingsProvider.register(ctx, CRAIG, 1, 2);
        ApothPaintingsProvider.register(ctx, ENCHANTING_TABLE, 2, 2);
        ApothPaintingsProvider.register(ctx, GEMS, 1, 1);
        ApothPaintingsProvider.register(ctx, TOWER, 1, 2);
        ApothPaintingsProvider.register(ctx, WINDOW, 2, 4);
    }

    private static void register(BootstrapContext<PaintingVariant> context, ResourceKey<PaintingVariant> key, int width, int height) {
        context.register(key, (Object)new PaintingVariant(width, height, key.location()));
    }

    private static ResourceKey<PaintingVariant> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.PAINTING_VARIANT, (ResourceLocation)Apotheosis.loc(name));
    }
}

