/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.gateways;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.tiers.Constraints;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public record TrueRandomInvaderWaveEntity(int count, Optional<String> desc) implements WaveEntity
{
    public static Codec<TrueRandomInvaderWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)1, (int)256).optionalFieldOf("count", (Object)1).forGetter(TrueRandomInvaderWaveEntity::count), (App)Codec.STRING.optionalFieldOf("desc").forGetter(TrueRandomInvaderWaveEntity::desc)).apply((Applicative)inst, TrueRandomInvaderWaveEntity::new));

    public LivingEntity createEntity(ServerLevel level, GatewayEntity gate) {
        GenContext ctx = GenContext.forPlayer(gate.summonerOrClosest());
        Invader realBoss = TrueRandomInvaderWaveEntity.getTrulyRandomItem(InvaderRegistry.INSTANCE, ctx);
        if (realBoss == null) {
            Apotheosis.LOGGER.error("Failed to resolve a random invader when generating a TrueRandomInvaderWaveEntity!");
            return null;
        }
        return realBoss.createBoss((ServerLevelAccessor)level, BlockPos.ZERO, ctx);
    }

    public MutableComponent getDescription() {
        MutableComponent desc = Apotheosis.lang("wave_entity", "true_random_invader", new Object[0]);
        return Gateways.lang((String)"tooltip", (String)"with_count", (Object[])new Object[]{this.getCount(), desc});
    }

    public boolean shouldFinalizeSpawn() {
        return false;
    }

    public Codec<? extends WaveEntity> getCodec() {
        return CODEC;
    }

    public int getCount() {
        return this.count;
    }

    public static TrueRandomInvaderWaveEntity createRandom(int count) {
        return new TrueRandomInvaderWaveEntity(count, Optional.empty());
    }

    @Nullable
    public static <T extends CodecProvider<T> & TieredWeights.Weighted> T getTrulyRandomItem(DynamicRegistry<T> registry, GenContext ctx) {
        Collection items = registry.getValues();
        ArrayList<CodecProvider> list = new ArrayList<CodecProvider>(items.size());
        for (CodecProvider item : items) {
            int weight = Math.max(0, ((TieredWeights.Weighted)item).weights().getWeight(ctx.tier(), ctx.luck()));
            Set<WorldTier> tiers = ((Constraints.Constrained)item).constraints().tiers();
            if (weight <= 0 || !tiers.isEmpty() && !tiers.contains((Object)ctx.tier())) continue;
            list.add(item);
        }
        if (list.isEmpty()) {
            return null;
        }
        return (T)((CodecProvider)list.get(ctx.rand().nextInt(list.size())));
    }
}

