/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.gui;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.container.item.SimpleItemContainer;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankMultiBlock;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesMenus;

public class TankMenu
extends BaseMenu {
    private final Predicate<Player> validator;
    final IFluidHandler tank;
    final ItemContainer tankContainer;

    public TankMenu(int id, Inventory inventory, RegistryFriendlyByteBuf data) {
        this(id, inventory, (IFluidHandler)new FluidTank(data.readInt()), (ItemContainer)new TankMultiBlock.Container(), false, player -> true);
        this.tankContainer.set(0, TankMenu.makeFluidItem((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)data)));
    }

    public TankMenu(int id, Inventory inventory, final IFluidHandler tank, ItemContainer container, boolean server, Predicate<Player> validator) {
        super(MachinesMenus.Tank, id, inventory, null, 192, 200);
        this.validator = validator;
        this.tank = tank;
        BaseMenu.Region playerRegion = this.createRegion();
        BaseMenu.Region inputRegion = this.createRegion();
        BaseMenu.Region outputRegion = this.createRegion();
        playerRegion.addShiftTargets(new BaseMenu.RegionHandle[]{inputRegion.reversed()});
        inputRegion.addShiftTargets(new BaseMenu.RegionHandle[]{playerRegion.reversed()});
        outputRegion.addShiftTargets(new BaseMenu.RegionHandle[]{playerRegion.reversed()});
        playerRegion.addPlayerSlots(20, 108, inventory);
        inputRegion.addSlot(38, 16, container, 0);
        outputRegion.addSlot(38, 52, container, 1);
        inputRegion.addSlot(146, 16, container, 2);
        outputRegion.addSlot(146, 52, container, 3);
        BaseMenu.Region tankRegion = this.createRegion();
        this.tankContainer = !server ? new SimpleItemContainer(1) : new SimpleItemContainer(this, 1){

            @NotNull
            public ItemStack get(int slot) {
                return TankMenu.makeFluidItem(tank.getFluidInTank(0));
            }
        };
        tankRegion.addSlot(-10000, -10000, this.tankContainer, 0).lock();
    }

    public void onMessage(int component, FriendlyByteBuf buf) {
    }

    public boolean stillValid(@NotNull Player player) {
        return this.validator.test(player);
    }

    public static void open(ServerPlayer player, final TankMultiBlock multiBlock) {
        final IFluidHandler fluidHandler = multiBlock.getFluidHandler();
        final ItemContainer container = multiBlock.getInventory();
        player.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"gui.xycraft_machines.tank");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
                return new TankMenu(id, inventory, fluidHandler, container, true, multiBlock::canAccess);
            }
        }, buf -> {
            buf.writeInt(fluidHandler.getTankCapacity(0));
            FluidStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)fluidHandler.getFluidInTank(0));
        });
    }

    private static ItemStack makeFluidItem(FluidStack fluidStack) {
        ItemStack stack = new ItemStack((ItemLike)MachinesContent.Block.Valve, 1);
        stack.set((Supplier)CoreItemDataComponents.FluidContainer, (Object)SimpleFluidContent.copyOf((FluidStack)fluidStack));
        return stack;
    }
}

