/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems.multiblocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.xynergy.XynergyNet;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.content.attachments.level.ProducerTickSystemLevelAttachment;

public abstract class ProducerTickSystem<TRecipe extends Recipe<TInput>, TInput extends RecipeInput>
extends ServerBlockTickSystem<ProducerTickSystemLevelAttachment<TRecipe, TInput>> {
    public abstract TInput getInput(ServerLevel var1, ProducerTickSystemLevelAttachment<TRecipe, TInput> var2, BlockPos var3, BlockState var4, long var5);

    public abstract long getTimeRequired(TRecipe var1);

    @Nullable
    public TRecipe getRecipe(ServerLevel level, ProducerTickSystemLevelAttachment<TRecipe, TInput> tickData, BlockPos pos, BlockState state, long currentStep) {
        if (!XynergyNet.hasXynergy((ServerLevel)level, (BlockPos)pos)) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return null;
        }
        Optional<RecipeHolder<TRecipe>> recipeOptional = tickData.getRecipeFor(pos.asLong(), this.getInput(level, tickData, pos, state, currentStep), (Level)level);
        if (recipeOptional.isEmpty()) {
            return null;
        }
        Recipe recipe = recipeOptional.get().value();
        long currentTime = (Long)blockEntity.getData(CoreAttachments.ProcessTime);
        long newTime = Math.max(currentTime - 1L, 0L);
        if (newTime != 0L) {
            blockEntity.setData(CoreAttachments.ProcessTime, (Object)newTime);
            return null;
        }
        blockEntity.setData(CoreAttachments.ProcessTime, (Object)this.getTimeRequired(recipe));
        return (TRecipe)recipe;
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
    }
}

