/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.ChargerAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class ChargerTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        ChargerAttachment data = (ChargerAttachment)blockEntity.getData(MachinesAttachments.Block.ChargerData);
        for (int i = 0; i < data.Input.size(); ++i) {
            IEnergyStorage cap;
            ItemStack stack = data.Input.get(i);
            if (stack.isEmpty() || (cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null || cap.receiveEnergy(1000000000, true) > 0) continue;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)data.Output.asHandler(), (ItemStack)stack, (boolean)false);
            data.Input.set(i, remainder);
        }
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.System.ChargerSystemData;
    }

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.Charger.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.Charger.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Charger at block position {} was moved without calling onRemove. Take note of how you moved it and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }
}

