/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.atmospheric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeWithStage;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeSerDes;
import tv.soaryn.xycraft.core.content.stages.IXyStage;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public record AtmosphericVacuumRecipe(TagKey<Biome> biome, Either<FluidStack, ItemStack> output, long ticks, Optional<IStage> requiredStage) implements IRecipeContent<Input, AtmosphericVacuumRecipe>,
IRecipeWithStage
{
    private static final MapCodec<AtmosphericVacuumRecipe> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.BIOME).fieldOf("valid_biomes").forGetter(AtmosphericVacuumRecipe::biome), (App)CodecUtils.Codecs.ContentObject.fieldOf("output").forGetter(AtmosphericVacuumRecipe::output), (App)Codec.LONG.fieldOf("ticks").forGetter(AtmosphericVacuumRecipe::ticks), (App)IXyStage.CODEC.optionalFieldOf("stage_required").forGetter(AtmosphericVacuumRecipe::requiredStage)).apply((Applicative)builder, AtmosphericVacuumRecipe::new));
    private static final BinarySerializer<TagKey<Biome>> BiomeTagSerDes = BinarySerializer.of((buf, value) -> buf.writeJsonWithCodec(TagKey.codec((ResourceKey)Registries.BIOME), value), buf -> (TagKey)buf.readJsonWithCodec(TagKey.codec((ResourceKey)Registries.BIOME)));
    private static final BinarySerializer<AtmosphericVacuumRecipe> SerDes = BinarySerializer.ofType(AtmosphericVacuumRecipe::new, AtmosphericVacuumRecipe::biome, BiomeTagSerDes, AtmosphericVacuumRecipe::output, (BinarySerializer)RecipeSerDes.OutputObjectSerDes, AtmosphericVacuumRecipe::ticks, (BinarySerializer)Serializer.LONG, AtmosphericVacuumRecipe::requiredStage, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)IXyStage.SerDes));

    public static RecipeSerDes<AtmosphericVacuumRecipe> register() {
        return RecipeSerDes.create(codec, SerDes);
    }

    public RecipeContent<AtmosphericVacuumRecipe> getContent() {
        return MachinesRecipeTypes.AtmosphericVacuum;
    }

    public IOMode outputMode() {
        return this.output.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public boolean matches(@NotNull Input input, @NotNull Level level) {
        return input.currentBiome().is(this.biome());
    }

    public Optional<IStage> getRequiredStage() {
        return this.requiredStage();
    }

    public static interface Input
    extends IRecipeContainer {
        public Holder<Biome> currentBiome();
    }
}

