/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.tank;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.core.utils.multiblock.CuboidDescriptor;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.machines.content.attachments.level.MultiTankLevelAttachment;
import tv.soaryn.xycraft.machines.content.multiblock.tank.FluidAmountContainer;
import tv.soaryn.xycraft.machines.content.multiblock.tank.IMultiTankMember;
import tv.soaryn.xycraft.machines.content.multiblock.tank.IOGroup;
import tv.soaryn.xycraft.machines.content.multiblock.tank.MultiTankFluidCache;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankMultiBlock;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankOperation;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public class MultiTank {
    private final UUID id;
    private final Int2ObjectOpenHashMap<TankMultiBlock> subTanks = new Int2ObjectOpenHashMap();
    private int nextSubTankId = 0;
    private FluidStack fluidType = FluidStack.EMPTY;
    private long capacity = 0L;
    private int gcd = 0;
    private boolean isValid;
    private ServerLevel level;
    public static final Codec<MultiTank> CODEC = RecordCodecBuilder.create((T builder) -> builder.group((App)UUIDUtil.CODEC.fieldOf("id").forGetter(MultiTank::getId), (App)CodecUtils.tupleOf((Codec)Codec.INT, TankMultiBlock.CODEC, Int2ObjectOpenHashMap::new).fieldOf("sub_tanks").forGetter(multiTank -> multiTank.subTanks), (App)Codec.INT.fieldOf("next_sub_tank_id").forGetter(multiTank -> multiTank.nextSubTankId), (App)CodecUtils.Codecs.FLUID_STACK_OPTIONAL.fieldOf("fluid").forGetter(MultiTank::getFluidType), (App)Codec.LONG.fieldOf("capacity").forGetter(multiTank -> multiTank.capacity), (App)Codec.INT.fieldOf("gcd").forGetter(multiTank -> multiTank.gcd), (App)Codec.BOOL.fieldOf("valid").forGetter(MultiTank::isValid)).apply((Applicative)builder, MultiTank::new));

    private MultiTank(UUID id, Int2ObjectOpenHashMap<TankMultiBlock> subTanks, int nextSubTankId, FluidStack fluid, long cap, int greatestCommonDivisor, boolean valid) {
        this.id = id;
        this.subTanks.putAll(subTanks);
        this.nextSubTankId = nextSubTankId;
        this.fluidType = fluid.copy();
        this.capacity = cap;
        this.gcd = greatestCommonDivisor;
        this.isValid = valid;
    }

    public void setup(ServerLevel level) {
        this.level = level;
        this.subTanks.forEach((subTankId, tankMultiBlock) -> {
            tankMultiBlock.initialize(this);
            CuboidDescriptor descriptor = tankMultiBlock.getDescriptor();
            if (tankMultiBlock.isValid()) {
                FastVolumeLookup.of((Level)level, TankMultiBlock.class).add(tankMultiBlock, descriptor.min(), descriptor.max());
            }
        });
    }

    private MultiTank(ServerLevel level) {
        this(level, UUID.randomUUID(), true);
    }

    private MultiTank(ServerLevel level, UUID id, boolean isValid) {
        this.id = id;
        this.level = level;
        this.isValid = isValid;
    }

    public UUID getId() {
        return this.id;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public FluidStack getFluidType() {
        return this.fluidType;
    }

    public void setFluidType(FluidStack fluidType) {
        this.fluidType = fluidType;
    }

    private long getFluidAmount() {
        long amount = 0L;
        for (TankMultiBlock tank : this.subTanks.values()) {
            amount += (long)tank.getFluidAmount();
        }
        return amount;
    }

    @Nullable
    public TankMultiBlock getMember(int id) {
        return (TankMultiBlock)this.subTanks.get(id);
    }

    public TankMultiBlock addSubTank(CuboidDescriptor descriptor, Long2ObjectOpenHashMap<BlockCapabilityCache<IMultiTankMember, Void>> members) {
        int id = this.nextSubTankId++;
        TankMultiBlock multiBlock = new TankMultiBlock(this, id, descriptor, members);
        this.subTanks.put(id, (Object)multiBlock);
        FastVolumeLookup.of((Level)this.level, TankMultiBlock.class).add((Object)multiBlock, descriptor.min(), descriptor.max());
        int multiBlockCapacity = multiBlock.getCapacity();
        this.capacity += (long)multiBlockCapacity;
        this.gcd = MathUtils.gcd((int)this.gcd, (int)multiBlockCapacity);
        return multiBlock;
    }

    public void removeSubTank(int id) {
        if (this.subTanks.size() == 1) {
            this.isValid = false;
            TankMultiBlock subTank = (TankMultiBlock)this.subTanks.values().iterator().next();
            FastVolumeLookup.of((Level)this.level, TankMultiBlock.class).remove((Object)subTank);
            return;
        }
        TankMultiBlock subTank = (TankMultiBlock)this.subTanks.remove(id);
        if (subTank != null) {
            FastVolumeLookup.of((Level)this.level, TankMultiBlock.class).remove((Object)subTank);
            this.capacity -= (long)subTank.getCapacity();
            this.gcd = FluidAmountContainer.getGCD((Iterable<? extends FluidAmountContainer>)this.subTanks.values());
        }
    }

    public int doFillLiquid(Iterable<IOGroup> fillOrder, FluidStack fluidType, int amount, IFluidHandler.FluidAction action) {
        MultiTankFluidCache cache = new MultiTankFluidCache(TankOperation.FILL);
        int remainder = amount;
        for (IOGroup group : fillOrder) {
            long storedFluid = cache.get(group);
            long capacity = group.getCapacity();
            long newStoredFluid = Math.min(storedFluid + (long)remainder, capacity);
            cache.set(group, newStoredFluid);
            if ((remainder -= (int)(newStoredFluid - storedFluid)) > 0) continue;
            break;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (this.getFluidType().isEmpty()) {
                this.setFluidType(fluidType.copy());
            }
            cache.commit();
        }
        return amount - remainder;
    }

    public FluidStack doDrainLiquid(Iterable<IOGroup> drainOrder, int amount, IFluidHandler.FluidAction action) {
        MultiTankFluidCache cache = new MultiTankFluidCache(TankOperation.DRAIN);
        int remainder = amount;
        for (IOGroup group : drainOrder) {
            long storedFluid = cache.get(group);
            int extracted = (int)Math.min(storedFluid, (long)remainder);
            long newStoredFluid = storedFluid - (long)extracted;
            cache.set(group, newStoredFluid);
            if ((remainder -= extracted) > 0) continue;
            break;
        }
        FluidStack drainedStack = this.getFluidType().copy();
        drainedStack.setAmount(amount - remainder);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            cache.commit();
            if (this.getFluidAmount() == 0L) {
                this.setFluidType(FluidStack.EMPTY);
            }
        }
        return drainedStack;
    }

    public int doFillGas(FluidStack fluidType, int amount, IFluidHandler.FluidAction action) {
        long fluidAmount = this.getFluidAmount();
        long newAmount = Math.min(fluidAmount + (long)amount, this.capacity);
        if (action == IFluidHandler.FluidAction.EXECUTE && newAmount != fluidAmount) {
            if (this.getFluidType().isEmpty()) {
                this.setFluidType(fluidType.copy());
            }
            FluidAmountContainer.distribute((Iterable<? extends FluidAmountContainer>)this.subTanks.values(), this.capacity, this.gcd, amount, TankOperation.FILL);
        }
        return (int)(newAmount - fluidAmount);
    }

    public FluidStack doDrainGas(int amount, IFluidHandler.FluidAction action) {
        long fluidAmount = this.getFluidAmount();
        if (fluidAmount == 0L) {
            return FluidStack.EMPTY;
        }
        long newAmount = Math.max(0L, fluidAmount - (long)amount);
        FluidStack drained = this.getFluidType().copy();
        drained.setAmount((int)(fluidAmount - newAmount));
        if (action == IFluidHandler.FluidAction.EXECUTE && newAmount != fluidAmount) {
            FluidAmountContainer.distribute((Iterable<? extends FluidAmountContainer>)this.subTanks.values(), this.capacity, this.gcd, amount, TankOperation.DRAIN);
            if (amount == 0) {
                this.setFluidType(FluidStack.EMPTY);
            }
        }
        return drained;
    }

    static MultiTank create(ServerLevel level) {
        MultiTank multiTank = new MultiTank(level);
        MultiTankLevelAttachment tankMap = (MultiTankLevelAttachment)level.getData(MachinesAttachments.Level.LevelTankData);
        tankMap.addTank(multiTank);
        return multiTank;
    }
}

