/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.IWrenchHandler;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.api.content.pipes.PipeGraph;
import tv.soaryn.xycraft.api.content.pipes.PipeNet;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.attachments.memory.CapabilityCacheAttachment;
import tv.soaryn.xycraft.core.content.attachments.memory.CapabilitySidedCacheAttachment;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.registries.CoreSystems;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.DirectionUtils;
import tv.soaryn.xycraft.core.utils.ShapeUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.attachments.ColorFilterAttachment;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeConnectionAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;
import tv.soaryn.xycraft.machines.content.systems.multiblocks.EnergyPipeExtractionSystem;
import tv.soaryn.xycraft.machines.content.systems.multiblocks.FluidPipeExtractionSystem;

public class PipeBlock<TGraph extends PipeGraph<TCapability, TGraph>, TCapability>
extends XyBlock.WithEntity
implements IColoredBlock,
SimpleWaterloggedBlock {
    public static final VoxelShape CoreShape = PipeBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape SideShape = PipeBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private static final Reference2ObjectOpenHashMap<Direction, AABB> shapes = (Reference2ObjectOpenHashMap)Util.make((Object)new Reference2ObjectOpenHashMap(), bounds -> {
        bounds.put(null, (Object)CoreShape.bounds().inflate((double)0.001f));
        Direction.stream().forEach(direction -> bounds.put(direction, (Object)ShapeUtils.rotate((AABB)SideShape.bounds().inflate((double)0.001f), (Direction)direction)));
    });
    private static final Int2ObjectMap<VoxelShape> ConnectionShapes = DirectionUtils.map((map, directions) -> map.put(DirectionUtils.hash((Iterable)directions), (Object)directions.stream().map(dir -> ShapeUtils.rotate((VoxelShape)SideShape, (Direction)dir)).reduce(CoreShape, Shapes::or, Shapes::or)));
    private static final BooleanProperty Encased = BooleanProperty.create((String)"encased");
    final Supplier<AttachmentType<CapabilitySidedCacheAttachment<TCapability>>> _attachment;
    Supplier<AttachmentType<PipeNetwork<TGraph, TCapability>>> _pipeNetwork;
    private static final VoxelShape _encasedShape = Shapes.join((VoxelShape)PipeBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)PipeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.NOT_SAME);

    public PipeBlock(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, XyBlockEntity> entityType, Supplier<AttachmentType<CapabilitySidedCacheAttachment<TCapability>>> attachment, Supplier<AttachmentType<PipeNetwork<TGraph, TCapability>>> pipeNetwork) {
        super(properties.requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get()), entityType);
        this._attachment = attachment;
        this._pipeNetwork = pipeNetwork;
        this.registerSystem(CoreSystems.Cleanup);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)Encased, (Comparable)Boolean.valueOf(false)));
        this.registerHasCapability();
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        builder.add(new Property[]{Encased});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (stack.is(Blocks.COPPER_BLOCK.asItem())) {
            boolean target = (Boolean)state.getValue((Property)Encased) == false;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Encased, (Comparable)Boolean.valueOf(target)));
            level.playSound(null, pos, target ? SoundEvents.COPPER_BULB_PLACE : SoundEvents.COPPER_BULB_HIT, SoundSource.BLOCKS, 0.8f, 1.0f);
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moving) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.getCapability(IPipeConnection.BLOCK, pos, null) != null) {
                PipeNet.addPipe((ServerLevel)serverLevel, (BlockPos)pos.immutable(), this._pipeNetwork);
            }
        }
        super.onPlace(blockState, level, pos.immutable(), newState, moving);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PipeNet.removePipe((ServerLevel)serverLevel, (BlockPos)pos.immutable(), this._pipeNetwork);
        }
        if ((blockEntity = level.getBlockEntity(pos)) == null) {
            super.onRemove(state, level, pos, oldState, moving);
            return;
        }
        if (!state.is(oldState.getBlock())) {
            CapabilityCacheAttachment adjPipeLookup = (CapabilityCacheAttachment)blockEntity.getData(MachinesAttachments.Block.AdjacentPipeCapabilityCache);
            for (Direction direction : Direction.values()) {
                PipeConnectionType logic;
                IPipeConnection cap = (IPipeConnection)adjPipeLookup.getCap(direction);
                if (cap == null || (logic = cap.getLogic(direction.getOpposite())) != PipeConnectionType.Transfer) continue;
                cap.setSide(direction.getOpposite(), PipeConnectionType.None);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.cleanRemove(serverLevel, pos);
            }
        }
        super.onRemove(state, level, pos, oldState, moving);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState otherState, @NotNull LevelAccessor accessor, @NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, otherState, accessor, pos, otherPos);
    }

    public static IWrenchHandler handleWrench(BlockEntity be, Void ignored) {
        return (player, interactionHand, hitResult) -> {
            boolean isMatchingPipe;
            Level level = be.getLevel();
            BlockState state = be.getBlockState();
            BlockPos pos = be.getBlockPos();
            Block patt0$temp = state.getBlock();
            if (!(patt0$temp instanceof PipeBlock)) {
                return null;
            }
            PipeBlock pipeBlock = (PipeBlock)patt0$temp;
            if (level == null) {
                return null;
            }
            boolean forwardCycle = !player.isShiftKeyDown();
            Vec3 hitLoc = hitResult.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            Direction directionHit = shapes.entrySet().stream().filter(s -> ((AABB)s.getValue()).contains(hitLoc)).findFirst().map(Map.Entry::getKey).orElse(hitResult.getDirection());
            if (level.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (ModifierKey.of((Player)player)) {
                directionHit = directionHit.getOpposite();
            }
            if (player.isShiftKeyDown()) {
                level.playSound(null, pos, SoundEvents.COPPER_BULB_TURN_ON, SoundSource.BLOCKS, 0.9f, 1.0f);
            } else {
                level.playSound(null, pos, SoundEvents.COPPER_BULB_TURN_OFF, SoundSource.BLOCKS, 0.9f, 1.0f);
            }
            CapabilitySidedCacheAttachment adjCapLookup = (CapabilitySidedCacheAttachment)be.getData(pipeBlock._attachment);
            CapabilityCacheAttachment adjPipeLookup = (CapabilityCacheAttachment)be.getData(MachinesAttachments.Block.AdjacentPipeCapabilityCache);
            IPipeConnection pipeConnection = (IPipeConnection)level.getCapability(IPipeConnection.BLOCK, pos, null);
            if (pipeConnection == null || !pipeConnection.canConnect(directionHit)) {
                return null;
            }
            PipeConnectionType prevLogic = pipeConnection.getLogic(directionHit);
            PipeConnectionType logic = prevLogic.cycle(forwardCycle);
            IPipeConnection otherPipe = (IPipeConnection)adjPipeLookup.getCap(directionHit);
            boolean canMerge = true;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PipeGraph currentGraph = PipeNet.getGraph((ServerLevel)serverLevel, (BlockPos)pos, pipeBlock._pipeNetwork);
                PipeGraph otherGraph = PipeNet.getGraph((ServerLevel)serverLevel, (BlockPos)pos.relative(directionHit), pipeBlock._pipeNetwork);
                if (currentGraph != null && !currentGraph.canMerge(otherGraph)) {
                    if (prevLogic != PipeConnectionType.None) {
                        pipeConnection.setSide(directionHit, PipeConnectionType.None);
                        return InteractionResult.SUCCESS;
                    }
                    return null;
                }
            }
            boolean bl = isMatchingPipe = otherPipe != null && otherPipe.canConnect(directionHit.getOpposite()) && pipeConnection.getHandledCap() == otherPipe.getHandledCap();
            if (logic == PipeConnectionType.Transfer && !isMatchingPipe && adjCapLookup.getCap(directionHit) == null) {
                logic = logic.cycle(forwardCycle);
            }
            if (isMatchingPipe) {
                PipeConnectionType otherLogic = otherPipe.getLogic(directionHit.getOpposite());
                if (logic == PipeConnectionType.None) {
                    switch (otherLogic) {
                        case None: {
                            break;
                        }
                        case Transfer: {
                            otherPipe.setSide(directionHit.getOpposite(), PipeConnectionType.None);
                            break;
                        }
                        case Insert: 
                        case Extract: {
                            logic = logic.cycle(forwardCycle);
                        }
                    }
                } else if (otherLogic == PipeConnectionType.None) {
                    otherPipe.setSide(directionHit.getOpposite(), PipeConnectionType.Transfer);
                }
            }
            if (level instanceof ServerLevel) {
                PipeConnectionAttachment pipeData;
                ServerLevel serverLevel = (ServerLevel)level;
                if (pipeBlock == MachinesContent.Block.PipeFluid.block()) {
                    if (logic == PipeConnectionType.Extract) {
                        ((FluidPipeExtractionSystem)((Object)((Object)MachinesSystems.FluidPipeExtraction.get()))).add(serverLevel, pos);
                    } else {
                        pipeData = (PipeConnectionAttachment)be.getData(MachinesAttachments.Block.PipeConnectionData);
                        if (!pipeData.map().containsValue((Object)PipeConnectionType.Extract)) {
                            ((FluidPipeExtractionSystem)((Object)((Object)MachinesSystems.FluidPipeExtraction.get()))).remove(serverLevel, pos);
                        }
                    }
                }
                if (pipeBlock == MachinesContent.Block.PipeEnergy.block()) {
                    if (logic == PipeConnectionType.Extract) {
                        ((EnergyPipeExtractionSystem)((Object)((Object)MachinesSystems.EnergyPipeExtraction.get()))).add(serverLevel, pos);
                    } else {
                        pipeData = (PipeConnectionAttachment)be.getData(MachinesAttachments.Block.PipeConnectionData);
                        if (!pipeData.map().containsValue((Object)PipeConnectionType.Extract)) {
                            ((EnergyPipeExtractionSystem)((Object)((Object)MachinesSystems.EnergyPipeExtraction.get()))).remove(serverLevel, pos);
                        }
                    }
                }
            }
            pipeConnection.setSide(directionHit, logic);
            level.setBlockAndUpdate(pos, state);
            level.invalidateCapabilities(pos);
            player.swing(interactionHand, true);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        };
    }

    protected void cleanRemove(ServerLevel level, BlockPos pos) {
        PipeNet.removePipe((ServerLevel)level, (BlockPos)pos.immutable(), this._pipeNetwork);
        if (this == MachinesContent.Block.PipeFluid.block()) {
            ((FluidPipeExtractionSystem)((Object)MachinesSystems.FluidPipeExtraction.get())).remove(level, pos);
        } else if (this == MachinesContent.Block.PipeEnergy.block()) {
            ((EnergyPipeExtractionSystem)((Object)MachinesSystems.EnergyPipeExtraction.get())).remove(level, pos);
        }
        super.cleanRemove(level, pos.immutable());
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.getValue((Property)Encased)).booleanValue()) {
            return _encasedShape;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return super.getShape(state, level, pos, context);
        }
        ObjectArraySet set = new ObjectArraySet();
        for (Map.Entry propertyEntry : ((PipeConnectionAttachment)blockEntity.getData(MachinesAttachments.Block.PipeConnectionData)).map().entrySet()) {
            if (propertyEntry.getValue() == PipeConnectionType.None) continue;
            set.add((Object)((Direction)propertyEntry.getKey()));
        }
        return (VoxelShape)ConnectionShapes.get(DirectionUtils.hash((Iterable)set));
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index == 3) {
            return ColorUtils.HSBtoFRGB((float)((float)(System.currentTimeMillis() % 10000L) / 10000.0f), (float)1.0f, (float)1.0f);
        }
        return super.getColorOfItem(stack, index);
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighborPos, boolean moving) {
        Integer prev;
        super.neighborChanged(state, level, pos, block, neighborPos, moving);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return;
        }
        int redstone = level.getBestNeighborSignal(pos);
        if (redstone != (prev = (Integer)blockEntity.getData(MachinesAttachments.Block.RedstoneData))) {
            blockEntity.setData(MachinesAttachments.Block.RedstoneData, (Object)redstone);
            level.invalidateCapabilities(pos);
        }
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter getter, BlockPos pos, int index) {
        if (getter == null) {
            return super.getColorOfBlock(state, getter, pos, index);
        }
        return switch (index) {
            case 1 -> {
                BlockEntity entity = getter.getBlockEntity(pos);
                if (entity == null) {
                    yield -1;
                }
                Level level = entity.getLevel();
                if (level == null) {
                    yield -1;
                }
                boolean hasSignal = level.hasNeighborSignal(pos);
                if (hasSignal) {
                    yield 0xFF0000;
                }
                yield -30686;
            }
            case 2 -> {
                BlockEntity entity = getter.getBlockEntity(pos);
                if (entity == null) {
                    yield -1;
                }
                Level level = entity.getLevel();
                if (level == null) {
                    yield -1;
                }
                boolean hasSignal = level.hasNeighborSignal(pos);
                if (hasSignal) {
                    yield -65536;
                }
                yield -11631105;
            }
            case 3 -> {
                BlockEntity entity = getter.getBlockEntity(pos);
                if (entity == null) {
                    yield -1;
                }
                ColorFilterAttachment data = (ColorFilterAttachment)entity.getData(MachinesAttachments.Block.ColorFilter);
                yield data.Filter.getColor();
            }
            default -> super.getColorOfBlock(state, getter, pos, index);
        };
    }
}

