/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.buffer;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.machines.content.attachments.BufferBlockAttachment;
import tv.soaryn.xycraft.machines.content.blocks.buffer.BufferBlockClient;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.gui.BufferMenu;
import tv.soaryn.xycraft.machines.temp.BlockOrientation;
import tv.soaryn.xycraft.machines.temp.IOrientableBlock;
import tv.soaryn.xycraft.machines.temp.IOrientationStrategy;
import tv.soaryn.xycraft.machines.temp.RelativeSide;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class BufferBlock
extends XyBlock.WithEntity
implements IOrientableBlock {
    private static final VoxelShape Shape = Shapes.join((VoxelShape)BufferBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)BufferBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.NOT_SAME);

    public BufferBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion(), Entity::new);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.StateDirection, (Comparable)Direction.DOWN)).setValue((Property)CoreStateProperties.Forward, (Comparable)Integer.valueOf(0)));
        this.registerHasCapability();
    }

    public void initializeClient(@NotNull Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(BufferBlockClient.particles());
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        for (Property<?> property : this.getOrientationStrategy().getProperties()) {
            builder.add(new Property[]{property});
        }
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        return this.getOrientationStrategy().getStateForPlacement(super.getStateForPlacement(ctx), ctx);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Entity) {
            Entity blockEntity2 = (Entity)blockEntity;
            level.playSound(null, pos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.15f, level.random.nextFloat() * 0.1f + 0.9f);
            if (!level.isClientSide() && !player.isFakePlayer()) {
                player.openMenu((MenuProvider)blockEntity2, pos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shape;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof Entity) {
            Entity entity = (Entity)blockEntity;
            BufferBlockAttachment data = (BufferBlockAttachment)entity.getData(MachinesAttachments.Block.BufferData);
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)data.Inventory.asVanillaContainer());
        }
        super.onRemove(state, level, pos, newState, moving);
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, MachinesContent.Block.Buffer.entity(), (blockEntity, context) -> {
            BufferBlockAttachment data = (BufferBlockAttachment)blockEntity.getData(MachinesAttachments.Block.BufferData);
            if (context == null) {
                return data.Top;
            }
            BlockState state = blockEntity.getBlockState();
            Direction dir = SidePartBlock.directionOf((BlockState)state);
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof IOrientableBlock) {
                IOrientableBlock orientableBlock = (IOrientableBlock)patt0$temp;
                BlockOrientation orientation = orientableBlock.getOrientation(state);
                RelativeSide relativeSide = orientation.getRelativeSide(context.getOpposite());
                return switch (relativeSide) {
                    default -> throw new MatchException(null, null);
                    case RelativeSide.TOP -> data.West;
                    case RelativeSide.BOTTOM -> data.East;
                    case RelativeSide.FRONT -> data.Top;
                    case RelativeSide.BACK -> data.Bottom;
                    case RelativeSide.LEFT -> data.South;
                    case RelativeSide.RIGHT -> data.North;
                };
            }
            if (dir.getOpposite() == context) {
                return data.Top;
            }
            if (dir == context) {
                return data.Bottom;
            }
            return null;
        });
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, (level, pos, originalState, be, context) -> (player, interactionHand, hit) -> {
            BlockState state = level.getBlockState(pos);
            Direction targeted = hit.getDirection();
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof IOrientableBlock) {
                IOrientableBlock orientableBlock = (IOrientableBlock)patt0$temp;
                BlockOrientation result = orientableBlock.getOrientation(state).rotateClockwiseAround(targeted.getAxis(), player.isShiftKeyDown() ? targeted.getAxisDirection().opposite() : targeted.getAxisDirection());
                result.setBlockState(level, pos);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return null;
        }, new Block[]{MachinesContent.Block.Buffer.block()});
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return IOrientationStrategy.full;
    }

    public static class Entity
    extends XyBlockEntity
    implements MenuProvider {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.Buffer.entity(), pos, state, new AttachmentType[]{MachinesAttachments.Block.BufferData.get()});
        }

        @NotNull
        public Component getDisplayName() {
            return Component.translatable((String)"gui.xycraft_machines.buffer");
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            BufferBlockAttachment data = (BufferBlockAttachment)this.getData(MachinesAttachments.Block.BufferData);
            return new BufferMenu(windowId, playerInventory, (BlockEntity)this, data.Inventory);
        }
    }
}

