/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.machines.content.attachments.FabricatorAttachment;
import tv.soaryn.xycraft.machines.content.blocks.fabricator.FabricatorBlock;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public class FabricatorRender
implements BlockEntityRenderer<FabricatorBlock.Entity> {
    private final ItemRenderer _itemRenderer;

    public FabricatorRender(BlockEntityRendererProvider.Context context) {
        this._itemRenderer = context.getItemRenderer();
    }

    public void render(@NotNull FabricatorBlock.Entity entity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, int overlay) {
        Level level = entity.getLevel();
        if (level == null) {
            return;
        }
        ItemContainer container = ((FabricatorAttachment)entity.getData(MachinesAttachments.Block.FabricatorData)).Ghost;
        poseStack.pushPose();
        Direction direction = (Direction)entity.getBlockState().getValue((Property)CoreStateProperties.StateDirection);
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(direction.getRotation());
        poseStack.translate(-0.5f, 0.5f, -0.5f);
        poseStack.pushPose();
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack itemstack = container.get(slot);
            if (itemstack.isEmpty()) continue;
            poseStack.pushPose();
            float pixel = 0.0625f;
            int r = slot % 3 * 3;
            int c = slot / 3 % 3 * 3;
            BakedModel bakedModel = this._itemRenderer.getModel(itemstack, level, null, 0);
            PoseStack tempPose = new PoseStack();
            bakedModel.applyTransform(ItemDisplayContext.FIXED, tempPose, false);
            float scale = pixel * 4.0f;
            poseStack.translate(pixel * (float)(5 + r), 0.0625f, pixel * (float)(5 + c));
            if (bakedModel.isGui3d()) {
                poseStack.scale(scale, scale, scale);
            } else {
                poseStack.scale(scale *= 0.5f, scale, scale);
            }
            this._itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, level, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
        poseStack.popPose();
    }
}

