/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects;

import com.mcwfurnitures.kikoz.objects.FurnitureObjectNonFaceable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Desk
extends FurnitureObjectNonFaceable {
    public static final DirectionProperty FACING_TWO_DIRECTIONAL = DirectionProperty.create((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST});
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.create((String)"connection", ConnectionStatus.class, (Enum[])new ConnectionStatus[]{ConnectionStatus.SINGLE, ConnectionStatus.MIDDLE, ConnectionStatus.LEFT, ConnectionStatus.RIGHT});
    protected static final VoxelShape NORTH_BASE = Shapes.or((VoxelShape)Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)15.0), Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0)});
    protected static final VoxelShape NORTH_MIDDLE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH_RIGHT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape NORTH_LEFT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape EAST_BASE = Shapes.or((VoxelShape)Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[]{Block.box((double)1.1, (double)0.0, (double)0.0, (double)3.1, (double)14.0, (double)16.1), Block.box((double)13.1, (double)0.0, (double)0.0, (double)15.1, (double)14.0, (double)16.1)});
    protected static final VoxelShape EAST_MIDDLE = Shapes.or((VoxelShape)Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST_RIGHT = Shapes.or((VoxelShape)Block.box((double)0.1, (double)14.0, (double)0.0, (double)16.1, (double)16.0, (double)16.1), (VoxelShape)Block.box((double)13.1, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0));
    protected static final VoxelShape EAST_LEFT = Shapes.or((VoxelShape)Block.box((double)0.1, (double)14.0, (double)0.1, (double)16.1, (double)16.0, (double)16.1), (VoxelShape)Block.box((double)1.1, (double)0.0, (double)0.0, (double)3.1, (double)14.0, (double)16.1));

    public Desk(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING_TWO_DIRECTIONAL, (Comparable)Direction.NORTH)).setValue(CONNECTION, (Comparable)((Object)ConnectionStatus.SINGLE)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        ConnectionStatus connectionStatus = (ConnectionStatus)((Object)state.getValue(CONNECTION));
        switch ((Direction)state.getValue((Property)FACING_TWO_DIRECTIONAL)) {
            case NORTH: {
                if (connectionStatus == ConnectionStatus.MIDDLE) {
                    return NORTH_MIDDLE;
                }
                if (connectionStatus == ConnectionStatus.LEFT) {
                    return NORTH_LEFT;
                }
                if (connectionStatus == ConnectionStatus.RIGHT) {
                    return NORTH_RIGHT;
                }
                return NORTH_BASE;
            }
        }
        if (connectionStatus == ConnectionStatus.MIDDLE) {
            return EAST_MIDDLE;
        }
        if (connectionStatus == ConnectionStatus.LEFT) {
            return EAST_LEFT;
        }
        if (connectionStatus == ConnectionStatus.RIGHT) {
            return EAST_RIGHT;
        }
        return EAST_BASE;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction originalDirection = (Direction)state.getValue((Property)FACING_TWO_DIRECTIONAL);
        Direction rotatedDirection = rot.rotate(originalDirection);
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.setValue((Property)FACING_TWO_DIRECTIONAL, (Comparable)rotatedDirection);
    }

    public BlockState mirror(BlockState state, Mirror mir) {
        Direction originalDirection = (Direction)state.getValue((Property)FACING_TWO_DIRECTIONAL);
        Direction rotatedDirection = mir == Mirror.FRONT_BACK ? originalDirection : originalDirection.getOpposite();
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.setValue((Property)FACING_TWO_DIRECTIONAL, (Comparable)rotatedDirection);
    }

    private BlockState TableState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = level.getBlockState(pos.north()).getBlock() == this;
        boolean east = level.getBlockState(pos.east()).getBlock() == this;
        boolean south = level.getBlockState(pos.south()).getBlock() == this;
        boolean west = level.getBlockState(pos.west()).getBlock() == this;
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.getValue((Property)FACING_TWO_DIRECTIONAL), north, east, south, west);
        return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        if (facing == Direction.NORTH) {
            if (north && south && !east && !west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && south && !east && !west) {
                return ConnectionStatus.RIGHT;
            }
            if (north && !south && !east && !west) {
                return ConnectionStatus.LEFT;
            }
        }
        if (facing == Direction.EAST) {
            if (!north && !south && east && west) {
                return ConnectionStatus.MIDDLE;
            }
            if (!north && !south && east && !west) {
                return ConnectionStatus.LEFT;
            }
            if (!north && !south && !east && west) {
                return ConnectionStatus.RIGHT;
            }
        }
        return ConnectionStatus.SINGLE;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        Direction currentFacing = (Direction)state.getValue((Property)FACING_TWO_DIRECTIONAL);
        BlockState defaultState = (BlockState)this.defaultBlockState().setValue((Property)FACING_TWO_DIRECTIONAL, (Comparable)currentFacing);
        level.setBlock(pos, this.TableState(defaultState, (LevelAccessor)level, pos), 2);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING_TWO_DIRECTIONAL, CONNECTION});
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livent, ItemStack stack) {
        this.TableState(state, (LevelAccessor)level, pos);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return (BlockState)this.TableState(state, level, pos).setValue((Property)FACING_TWO_DIRECTIONAL, (Comparable)((Direction)state.getValue((Property)FACING_TWO_DIRECTIONAL)));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction playerFacing = context.getHorizontalDirection();
        return (BlockState)this.TableState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos()).setValue((Property)FACING_TWO_DIRECTIONAL, (Comparable)(switch (playerFacing) {
            case Direction.NORTH -> Direction.EAST;
            case Direction.SOUTH -> Direction.EAST;
            case Direction.EAST -> Direction.NORTH;
            case Direction.WEST -> Direction.NORTH;
            default -> Direction.NORTH;
        }));
    }

    public void placeAt(Level level, BlockPos pos, int number) {
        level.setBlock(pos, this.defaultBlockState(), number);
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        SINGLE("single"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

