/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedCenteredPanelBlock
extends FramedBlock {
    public FramedCenteredPanelBlock() {
        super(BlockType.FRAMED_CENTERED_PANEL);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_NE, FramedProperties.SOLID, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            Direction dir = modCtx.getHorizontalDirection();
            if (dir == Direction.SOUTH || dir == Direction.WEST) {
                dir = dir.getOpposite();
            }
            return (BlockState)state.setValue((Property)FramedProperties.FACING_NE, (Comparable)dir);
        })).withWater()).build();
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        if (rot == Rotation.NONE || rot == Rotation.CLOCKWISE_180) {
            return state;
        }
        return (BlockState)state.cycle((Property)FramedProperties.FACING_NE);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }
}

