/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedStairsGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;
    private final StairsShape shape;

    public FramedStairsGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.top = ctx.state().getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        this.shape = (StairsShape)ctx.state().getValue((Property)BlockStateProperties.STAIRS_SHAPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.top && quadDir == Direction.DOWN || !this.top && quadDir == Direction.UP) {
            this.createCenterQuads(quadMap.get(null), quad);
            this.createTopBottomQuads(quadMap.get(quadDir), quad);
        } else if (!Utils.isY(quad.getDirection())) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(quadDir));
            this.createSideQuads(quadMap, quad, quadDir);
        }
    }

    private void createCenterQuads(List<BakedQuad> quadList, BakedQuad quad) {
        if (this.shape == StairsShape.STRAIGHT || this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadList);
        }
        if (this.shape != StairsShape.STRAIGHT) {
            boolean opposite = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT;
            boolean left = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.INNER_LEFT;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(opposite ? this.dir.getOpposite() : this.dir, 0.5f)).apply(Modifiers.cutTopBottom(left ? this.dir.getCounterClockWise() : this.dir.getClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadList);
        }
    }

    private void createTopBottomQuads(List<BakedQuad> quadList, BakedQuad quad) {
        if (this.shape == StairsShape.STRAIGHT || this.shape == StairsShape.INNER_LEFT || this.shape == StairsShape.INNER_RIGHT) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).export(quadList);
        }
        if (this.shape != StairsShape.STRAIGHT) {
            boolean outer = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.OUTER_RIGHT;
            boolean left = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.INNER_LEFT;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(outer ? this.dir.getOpposite() : this.dir, 0.5f)).apply(Modifiers.cutTopBottom(left ? this.dir.getClockWise() : this.dir.getCounterClockWise(), 0.5f)).export(quadList);
        }
    }

    private void createSideQuads(QuadMap quadMap, BakedQuad quad, Direction quadDir) {
        boolean left;
        boolean inner = this.shape == StairsShape.INNER_LEFT || this.shape == StairsShape.INNER_RIGHT;
        boolean bl = left = this.shape == StairsShape.OUTER_LEFT || this.shape == StairsShape.INNER_LEFT;
        if (quadDir == this.dir.getOpposite()) {
            Direction cutDir = left != inner ? this.dir.getClockWise() : this.dir.getCounterClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).applyIf(Modifiers.cutSideLeftRight(cutDir, 0.5f), this.shape != StairsShape.STRAIGHT).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            if (inner) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(left ? this.dir.getClockWise() : this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else if (quadDir == this.dir && !inner) {
            Direction cutDir = left ? this.dir.getClockWise() : this.dir.getCounterClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir.getAxis() != this.dir.getAxis()) {
            boolean innerRight;
            boolean outerLeft = this.shape == StairsShape.OUTER_LEFT && quadDir == this.dir.getClockWise();
            boolean outerRight = this.shape == StairsShape.OUTER_RIGHT && quadDir == this.dir.getCounterClockWise();
            boolean innerLeft = this.shape == StairsShape.INNER_LEFT && quadDir == this.dir.getClockWise();
            boolean bl2 = innerRight = this.shape == StairsShape.INNER_RIGHT && quadDir == this.dir.getCounterClockWise();
            if (this.shape == StairsShape.STRAIGHT || !inner || innerLeft || innerRight) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), outerLeft || outerRight).export(quadMap.get(outerLeft || outerRight ? null : quadDir));
            }
            if (innerLeft || innerRight) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        }
    }
}

