/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class PrismOutlineRenderer
implements OutlineRenderer {
    protected static final Quaternionf[] YN_DIR = PrismOutlineRenderer.makeQuaternionArray();

    @Override
    public void draw(BlockState state, PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.5f, 0.5f, 1.0f, 1.0f, 0.0f, 1.0f);
        this.drawCenterAndTriangle(pstack, builder);
    }

    protected void drawCenterAndTriangle(PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.5f, 0.5f, 0.0f, 0.5f, 0.5f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.5f, 0.5f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotateMatrix(PoseStack pstack, BlockState state) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.getValue(PropertyHolder.FACING_AXIS));
        Direction facing = dirAxis.direction();
        Direction.Axis axis = dirAxis.axis();
        if (Utils.isY(facing)) {
            if (facing == Direction.DOWN) {
                pstack.mulPose(Quaternions.ZP_180);
            }
            if (axis == Direction.Axis.X) {
                pstack.mulPose(Quaternions.YP_90);
            }
        } else {
            if (facing != Direction.SOUTH) {
                pstack.mulPose(YN_DIR[facing.get2DDataValue()]);
            }
            if (axis != Direction.Axis.Y) {
                pstack.mulPose(Quaternions.ZP_90);
            }
            pstack.mulPose(Quaternions.XP_90);
        }
    }

    private static Quaternionf[] makeQuaternionArray() {
        Quaternionf[] array = new Quaternionf[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.get2DDataValue()] = Axis.YN.rotation(1.5707964f * (float)dir.get2DDataValue());
        }
        return array;
    }
}

