/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.inventory;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.logistics.inventory.slot.SlotItemHandler;

public abstract class AbstractContainer
extends AbstractContainerMenu {
    public final Player player;
    public final Level world;
    public static final AbstractContainerMenu DUMMY = new AbstractContainerMenu(null, 0){

        public boolean stillValid(Player playerIn) {
            return true;
        }

        public ItemStack quickMoveStack(Player player, int index) {
            return ItemStack.EMPTY;
        }
    };

    public AbstractContainer(@Nullable MenuType<?> type, int id, Inventory inventory, FriendlyByteBuf buffer) {
        this(type, id, inventory);
    }

    public AbstractContainer(@Nullable MenuType<?> type, int id, Inventory inventory) {
        super(type, id);
        this.player = inventory.player;
        this.world = this.player.level();
        this.init(inventory);
    }

    protected void init(Inventory inventory) {
    }

    public void initializeContents(int stateId, List<ItemStack> items, ItemStack carried) {
        for (int i = 0; i < items.size(); ++i) {
            Slot slot = this.getSlot(i);
            if (slot instanceof SlotItemHandler) {
                SlotItemHandler slotIh = (SlotItemHandler)slot;
                slotIh.initialize(items.get(i));
                continue;
            }
            slot.set(items.get(i));
        }
        this.setCarried(carried);
        this.stateId = stateId;
    }

    protected void addPlayerInventory(Inventory playerInventory, int x, int y, int yDif) {
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + l * 9 + 9, x + k * 18, l * 18 + y));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, x + i1 * 18, y + 54 + yDif));
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }
}

