/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.registry.IVariant;

public class AbstractTickableTile<V extends IVariant, B extends AbstractBlock<V, B>>
extends AbstractTileEntity<V, B> {
    private int syncTicks;
    public int ticks;

    public AbstractTickableTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AbstractTickableTile(BlockEntityType<?> type, BlockPos pos, BlockState state, V variant) {
        super(type, pos, state, variant);
    }

    public void tick() {
        Level world = this.level;
        if (world != null) {
            int i;
            if (this.ticks == 0) {
                this.onFirstTick(world);
            }
            if (this.doPostTicks(world) && (i = this.postTick(world)) > -1 && !this.isRemote()) {
                this.sync(i);
            }
            ++this.ticks;
            if (!this.isRemote()) {
                if (this.syncTicks > -1) {
                    --this.syncTicks;
                }
                if (this.syncTicks == 0) {
                    this.sync();
                }
            } else {
                this.clientTick(world);
            }
        }
    }

    protected void onFirstTick(Level world) {
    }

    protected boolean doPostTicks(Level world) {
        return true;
    }

    protected int postTick(Level world) {
        return -1;
    }

    protected void clientTick(Level world) {
    }

    public void sync(int delay) {
        if (!(this.isRemote() || this.syncTicks > 0 && delay >= this.syncTicks)) {
            this.syncTicks = delay;
        }
    }
}

