/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.client.render.tile.ReactorItemRenderer;
import owmii.powah.config.v2.types.GeneratorConfig;
import owmii.powah.lib.item.EnergyBlockItem;

public class ReactorItem
extends EnergyBlockItem<GeneratorConfig, ReactorBlock> {
    private final ThreadLocal<Boolean> ALLOW_PLACEMENT = ThreadLocal.withInitial(() -> false);

    public ReactorItem(ReactorBlock block, Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        super(block, properties, group);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ReactorItemRenderer();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionResult place(BlockPlaceContext context) {
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        if (player == null || owmii.powah.util.Player.isFake(player)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (player.getInventory().countItem(stack.getItem()) < 36 && !player.isCreative()) {
            player.displayClientMessage((Component)Component.translatable((String)"chat.powah.not.enough.blocks", (Object[])new Object[]{String.valueOf(ChatFormatting.YELLOW) + (36 - player.getInventory().countItem(stack.getItem())) + String.valueOf(ChatFormatting.RED)}).withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.getClickedPos();
        List list = BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 3, 1)).map(BlockPos::immutable).collect(Collectors.toList());
        for (BlockPos blockPos : list) {
            if (context.getLevel().getBlockState(blockPos).canBeReplaced()) continue;
            return InteractionResult.FAIL;
        }
        List entities = context.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(1.0, 3.0, 1.0));
        if (!entities.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (!player.isCreative()) {
            if (stack.getCount() < 36) {
                int held = stack.getCount();
                stack.setCount(0);
                int taken = ContainerHelper.clearOrCountMatchingItems((Container)player.getInventory(), s -> s.is((Item)this), (int)(36 - held), (boolean)false);
                if (taken + held != 36) {
                    throw new IllegalStateException();
                }
                stack.setCount(1);
            } else {
                stack.shrink(35);
            }
        }
        this.ALLOW_PLACEMENT.set(true);
        try {
            InteractionResult interactionResult = super.place(context);
            return interactionResult;
        }
        finally {
            this.ALLOW_PLACEMENT.set(false);
        }
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return this.ALLOW_PLACEMENT.get() != false && super.placeBlock(context, state);
    }
}

