/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import owmii.powah.Powah;
import owmii.powah.block.Blcks;
import owmii.powah.compat.common.FluidCoolant;
import owmii.powah.compat.common.MagmatorFuel;
import owmii.powah.compat.common.PassiveHeatSource;
import owmii.powah.compat.common.SolidCoolant;
import owmii.powah.compat.jei.JeiEnergizingCategory;
import owmii.powah.compat.jei.JeiFluidCoolantCategory;
import owmii.powah.compat.jei.JeiHeatSourceCategory;
import owmii.powah.compat.jei.JeiMagmatorCategory;
import owmii.powah.compat.jei.JeiReactorFuelCategory;
import owmii.powah.compat.jei.JeiSolidCoolantCategory;
import owmii.powah.item.Itms;
import owmii.powah.lib.client.screen.container.AbstractContainerScreen;

@JeiPlugin
public class PowahJeiPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new JeiEnergizingCategory(helper), new JeiFluidCoolantCategory(helper), new JeiHeatSourceCategory(helper), new JeiMagmatorCategory(helper), new JeiReactorFuelCategory(helper), new JeiSolidCoolantCategory(helper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)Blcks.ENERGIZING_ORB.get(), new RecipeType[]{JeiEnergizingCategory.TYPE.get()});
        Blcks.ENERGIZING_ROD.getAll().forEach(block -> registration.addRecipeCatalyst((ItemLike)block, new RecipeType[]{JeiEnergizingCategory.TYPE.get()}));
        Blcks.MAGMATOR.getAll().forEach(block -> registration.addRecipeCatalyst((ItemLike)block, new RecipeType[]{JeiMagmatorCategory.TYPE}));
        Blcks.THERMO_GENERATOR.getAll().forEach(block -> {
            registration.addRecipeCatalyst((ItemLike)block, new RecipeType[]{JeiHeatSourceCategory.TYPE});
            registration.addRecipeCatalyst((ItemLike)block, new RecipeType[]{JeiFluidCoolantCategory.TYPE});
        });
        Blcks.REACTOR.getAll().forEach(block -> {
            registration.addRecipeCatalyst((ItemLike)block, new RecipeType[]{JeiSolidCoolantCategory.TYPE});
            registration.addRecipeCatalyst((ItemLike)block, new RecipeType[]{JeiFluidCoolantCategory.TYPE});
            registration.addRecipeCatalyst((ItemLike)block, new RecipeType[]{JeiReactorFuelCategory.TYPE});
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JeiEnergizingCategory.TYPE.get(), JeiEnergizingCategory.getAllRecipes());
        registration.addRecipes(JeiMagmatorCategory.TYPE, MagmatorFuel.getAll());
        registration.addRecipes(JeiFluidCoolantCategory.TYPE, FluidCoolant.getAll());
        registration.addRecipes(JeiSolidCoolantCategory.TYPE, SolidCoolant.getAll());
        registration.addRecipes(JeiHeatSourceCategory.TYPE, PassiveHeatSource.getAll());
        registration.addRecipes(JeiReactorFuelCategory.TYPE, JeiReactorFuelCategory.createRecipes());
        if (Powah.config().general.player_aerial_pearl) {
            registration.addIngredientInfo((ItemLike)Itms.PLAYER_AERIAL_PEARL.get(), new Component[]{Component.translatable((String)"jei.powah.player_aerial_pearl")});
        }
        if (Powah.config().general.dimensional_binding_card) {
            registration.addIngredientInfo((ItemLike)Itms.BINDING_CARD_DIM.get(), new Component[]{Component.translatable((String)"jei.powah.binding_card_dim")});
        }
        if (Powah.config().general.lens_of_ender) {
            registration.addIngredientInfo((ItemLike)Itms.LENS_OF_ENDER.get(), new Component[]{Component.translatable((String)"jei.powah.lens_of_ender")});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractContainerScreen.class, new IGuiContainerHandler<AbstractContainerScreen<?>>(this){

            public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen<?> containerScreen) {
                return containerScreen.getExtraAreas();
            }
        });
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"powah", (String)"main");
    }
}

