/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.container;

import java.util.ArrayList;
import java.util.OptionalInt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.thermo.ThermoTile;
import owmii.powah.client.screen.Textures;
import owmii.powah.inventory.ThermoContainer;
import owmii.powah.lib.client.screen.container.AbstractEnergyScreen;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.util.Util;

public class ThermoScreen
extends AbstractEnergyScreen<ThermoTile, ThermoContainer> {
    public ThermoScreen(ThermoContainer container, Inventory inv, Component title) {
        super(container, inv, title, Textures.THERMO);
        this.addTankArea(((ThermoTile)this.te)::getTank, 157, 5, 14, 65, "info.lollipop.coolant", (content, lines) -> {
            OptionalInt coolant = PowahAPI.getCoolant(content.getFluid());
            if (coolant.isPresent()) {
                lines.add(Component.translatable((String)"info.lollipop.temperature").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.temperature.c", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + coolant.getAsInt()}).withStyle(ChatFormatting.DARK_GRAY)));
            }
        });
    }

    @Override
    protected void drawBackground(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        super.drawBackground(gui, partialTicks, mouseX, mouseY);
        Textures.THERMO_GAUGE.drawScalableH(gui, ((ThermoTile)this.te).getEnergy().subSized(), this.leftPos + 5, this.topPos + 5);
        long percent = ((ThermoTile)this.te).getGeneration() > 0L ? 100L * ((ThermoTile)this.te).generating / ((ThermoTile)this.te).getGeneration() : 0L;
        gui.drawString(this.font, percent + "% (" + ((ThermoTile)this.te).generating + " FE/t)", this.leftPos + 34, this.topPos + 10, 0x555555, false);
    }

    @Override
    protected void renderTooltip(GuiGraphics gui, int mouseX, int mouseY) {
        super.renderTooltip(gui, mouseX, mouseY);
        if (Textures.FURNATOR_GAUGE.isMouseOver(this.leftPos + 5, this.topPos + 5, mouseX, mouseY)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            Energy energy = ((ThermoTile)this.te).getEnergy();
            list.add(Component.translatable((String)"info.lollipop.stored").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(energy.getStored()), Util.numFormat(energy.getCapacity())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.generates").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(((ThermoTile)this.te).getGeneration())}).withStyle(ChatFormatting.DARK_GRAY)));
            list.add(Component.translatable((String)"info.lollipop.max.extract").withStyle(ChatFormatting.GRAY).append(Text.COLON).append((Component)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.numFormat(energy.getMaxExtract())}).withStyle(ChatFormatting.DARK_GRAY)));
            gui.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
    }
}

