/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.transmitter;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.transmitter.PlayerTransmitterTile;
import owmii.powah.config.v2.types.ChargingConfig;
import owmii.powah.inventory.PlayerTransmitterContainer;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.inventory.AbstractContainer;

public class PlayerTransmitterBlock
extends AbstractEnergyBlock<ChargingConfig, PlayerTransmitterBlock> {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final VoxelShape TOP_SHAPE = Shapes.or((VoxelShape)PlayerTransmitterBlock.box(6.0, 8.0, 6.0, 10.0, 12.0, 10.0), (VoxelShape[])new VoxelShape[]{PlayerTransmitterBlock.box(7.0, 4.5, 7.0, 9.0, 8.0, 9.0), PlayerTransmitterBlock.box(4.0, 0.5, 4.0, 12.0, 1.5, 12.0), PlayerTransmitterBlock.box(4.0, 2.0, 4.0, 12.0, 3.0, 12.0), PlayerTransmitterBlock.box(4.0, 3.5, 4.0, 12.0, 4.5, 12.0), PlayerTransmitterBlock.box(1.0, -15.0, 1.0, 15.0, -1.0, 15.0), PlayerTransmitterBlock.box(4.0, -1.0, 4.0, 12.0, 0.0, 12.0)});
    public static final VoxelShape BOTTOM_SHAPE = Shapes.or((VoxelShape)PlayerTransmitterBlock.box(6.0, 24.0, 6.0, 10.0, 28.0, 10.0), (VoxelShape[])new VoxelShape[]{PlayerTransmitterBlock.box(7.0, 20.5, 7.0, 9.0, 24.0, 9.0), PlayerTransmitterBlock.box(4.0, 16.5, 4.0, 12.0, 17.5, 12.0), PlayerTransmitterBlock.box(4.0, 18.0, 4.0, 12.0, 19.0, 12.0), PlayerTransmitterBlock.box(4.0, 19.5, 4.0, 12.0, 20.5, 12.0), PlayerTransmitterBlock.box(1.0, 1.0, 1.0, 15.0, 15.0, 15.0), PlayerTransmitterBlock.box(4.0, 15.0, 4.0, 12.0, 16.0, 12.0)});

    public PlayerTransmitterBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)TOP) != false ? TOP_SHAPE : BOTTOM_SHAPE;
    }

    @Override
    public ChargingConfig getConfig() {
        return Powah.config().devices.player_transmitters;
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        return super.getBlockItem(properties.stacksTo(1), (ResourceKey)group);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)TOP) == false ? new PlayerTransmitterTile(pos, state, (Tier)this.variant) : null;
    }

    @Override
    @Nullable
    public AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof PlayerTransmitterTile) {
            return new PlayerTransmitterContainer(id, inventory, (PlayerTransmitterTile)te);
        }
        return null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result) {
        BlockState bottomState;
        Block block;
        if (((Boolean)state.getValue((Property)TOP)).booleanValue() && (block = (bottomState = world.getBlockState(pos.below())).getBlock()) instanceof PlayerTransmitterBlock) {
            PlayerTransmitterBlock transmitterBlock = (PlayerTransmitterBlock)block;
            return transmitterBlock.useWithoutItem(bottomState, world, pos.below(), player, result);
        }
        return super.useWithoutItem(state, world, pos, player, result);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockState bottomState = world.getBlockState(currentPos.below());
        BlockState topState = world.getBlockState(currentPos.above());
        if (!((Boolean)state.getValue((Property)TOP)).booleanValue() && !(topState.getBlock() instanceof PlayerTransmitterBlock) || ((Boolean)state.getValue((Property)TOP)).booleanValue() && !(bottomState.getBlock() instanceof PlayerTransmitterBlock)) {
            world.setBlock(currentPos, Blocks.AIR.defaultBlockState(), 3);
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        if (!((Boolean)state.getValue((Property)TOP)).booleanValue() && world.isEmptyBlock(pos.above())) {
            world.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return (Boolean)state.getValue((Property)TOP) != false ? super.canSurvive(state, world, pos) : world.isEmptyBlock(pos.above()) || world.getBlockState(pos.above()).getBlock() == this;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.isCreative()) {
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
            return state;
        }
        BlockEntity tileEntity = world.getBlockEntity((Boolean)state.getValue((Property)TOP) != false ? pos.below() : pos);
        if (!world.isClientSide() && tileEntity instanceof PlayerTransmitterTile) {
            PlayerTransmitterTile tile = (PlayerTransmitterTile)tileEntity;
            ItemStack stack = tile.storeToStack(new ItemStack((ItemLike)this));
            PlayerTransmitterBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        return state;
    }

    @Override
    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{TOP}));
    }
}

