/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.components.PowahComponents;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.item.WrenchItem;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.client.handler.IHud;
import owmii.powah.lib.client.util.Draw;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.util.Util;
import owmii.powah.util.math.V3d;

public class EnergizingRodBlock
extends AbstractEnergyBlock<EnergyConfig, EnergizingRodBlock>
implements SimpleWaterloggedBlock,
IWrenchable,
IHud {
    public EnergizingRodBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
        this.setStateProps(state -> (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN));
        this.shapes.put(Direction.UP, Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 13.0, 7.0, 9.0, 16.0, 9.0), (VoxelShape)EnergizingRodBlock.box(7.25, 9.0, 7.25, 8.75, 13.0, 8.75), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.DOWN, Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 0.0, 7.0, 9.0, 3.0, 9.0), (VoxelShape)EnergizingRodBlock.box(7.25, 3.0, 7.25, 8.75, 7.0, 8.75), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.NORTH, Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 0.0, 9.0, 9.0, 3.0), (VoxelShape)EnergizingRodBlock.box(7.25, 7.25, 3.0, 8.75, 8.75, 7.0), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.SOUTH, Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 13.0, 9.0, 9.0, 16.0), (VoxelShape)EnergizingRodBlock.box(7.25, 7.25, 13.0, 8.75, 8.75, 9.0), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.WEST, Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.join((VoxelShape)EnergizingRodBlock.box(0.0, 7.0, 7.0, 3.0, 9.0, 9.0), (VoxelShape)EnergizingRodBlock.box(3.0, 7.25, 7.25, 7.0, 8.75, 8.75), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.EAST, Shapes.join((VoxelShape)EnergizingRodBlock.box(7.0, 7.0, 7.0, 9.0, 9.0, 9.0), (VoxelShape)Shapes.join((VoxelShape)EnergizingRodBlock.box(13.0, 7.0, 7.0, 16.0, 9.0, 9.0), (VoxelShape)EnergizingRodBlock.box(13.0, 7.25, 7.25, 9.0, 8.75, 8.75), (BooleanOp)BooleanOp.OR), (BooleanOp)BooleanOp.OR));
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable ResourceKey<CreativeModeTab> group) {
        return super.getBlockItem(properties.stacksTo(1), (ResourceKey)group);
    }

    @Override
    public EnergyConfig getConfig() {
        return Powah.config().devices.energizing_rods;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnergizingRodTile(pos, state, (Tier)this.variant);
    }

    @Override
    protected boolean checkValidEnergySide() {
        return true;
    }

    @Override
    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, worldIn, pos, oldState, isMoving);
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof EnergizingRodTile) {
            this.setOrbPos(worldIn, pos, (EnergizingRodTile)tileEntity);
        }
    }

    public void setOrbPos(Level worldIn, BlockPos pos, EnergizingRodTile tile) {
        int range = Powah.config().general.energizing_range;
        List list = BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).map(BlockPos::immutable).collect(Collectors.toList());
        for (BlockPos pos1 : list) {
            BlockEntity tileEntity1;
            if (pos1.equals((Object)BlockPos.ZERO) || !((tileEntity1 = worldIn.getBlockEntity(pos1)) instanceof EnergizingOrbTile)) continue;
            tile.setOrbPos(pos1);
            break;
        }
    }

    @Override
    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    @Override
    public boolean onWrench(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, WrenchMode mode, Vec3 hit) {
        BlockEntity tileEntity;
        ItemStack stack;
        if (mode.link() && (stack = player.getItemInHand(hand)).getItem() instanceof WrenchItem && (tileEntity = world.getBlockEntity(pos)) instanceof EnergizingRodTile) {
            EnergizingRodTile rod = (EnergizingRodTile)tileEntity;
            BlockPos orbPos = (BlockPos)stack.get(PowahComponents.LINK_ORB_POS);
            if (orbPos != null) {
                if (world.getBlockEntity(orbPos) instanceof EnergizingOrbTile) {
                    V3d v3d = V3d.from(orbPos);
                    if ((int)v3d.distance(pos) <= Powah.config().general.energizing_range) {
                        rod.setOrbPos(orbPos);
                        player.displayClientMessage((Component)Component.translatable((String)"chat.powah.wrench.link.done").withStyle(ChatFormatting.GOLD), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"chat.powah.wrench.link.fail").withStyle(ChatFormatting.RED), true);
                    }
                }
                stack.remove(PowahComponents.LINK_ORB_POS);
            } else {
                stack.set(PowahComponents.LINK_ROD_POS, (Object)pos);
                player.displayClientMessage((Component)Component.translatable((String)"chat.powah.wrench.link.start").withStyle(ChatFormatting.YELLOW), true);
            }
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(GuiGraphics gui, BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result, @Nullable BlockEntity te) {
        if (te instanceof EnergizingRodTile) {
            EnergizingRodTile rod = (EnergizingRodTile)te;
            RenderSystem.getModelViewStack().pushMatrix();
            RenderSystem.enableBlend();
            Minecraft mc = Minecraft.getInstance();
            Font font = mc.font;
            int x = mc.getWindow().getGuiScaledWidth() / 2;
            int y = mc.getWindow().getGuiScaledHeight();
            String s = String.valueOf(ChatFormatting.GRAY) + I18n.get((String)"info.lollipop.stored", (Object[])new Object[0]) + ": " + I18n.get((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(rod.getEnergy().getEnergyStored()), Util.numFormat(rod.getEnergy().getCapacity())});
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"lollipop", (String)"textures/gui/ov_energy.png"));
            Draw.drawTexturedModalRect(gui, x - 37 - 1, y - 80, 0, 0, 74, 9, 0.0f);
            Draw.gaugeH(x - 37, y - 79, 72, 16, 0, 9, ((EnergizingRodTile)te).getEnergy());
            gui.drawString(font, s, Math.round((float)x - (float)font.width(s) / 2.0f), y - 67, 0xFFFFFF);
            RenderSystem.disableBlend();
            RenderSystem.getModelViewStack().popMatrix();
        }
        return true;
    }
}

