/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ForwardingContainer;
import mods.railcraft.world.module.BaseModule;
import mods.railcraft.world.module.ModuleProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;

public abstract class ContainerModule<T extends ModuleProvider>
extends BaseModule<T>
implements ForwardingContainer {
    protected final AdvancedContainer container;

    protected ContainerModule(T provider, int size) {
        super(provider);
        this.container = new AdvancedContainer(size).listener((ModuleProvider)provider);
    }

    @Override
    public boolean stillValid(Player player) {
        return this.provider.isStillValid(player);
    }

    @Override
    public Container container() {
        return this.container;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.put("container", (Tag)this.container.createTag(provider));
        return tag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        super.deserializeNBT(provider, tag);
        this.container.fromTag(tag.getList("container", 10), provider);
    }
}

