/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.multiblock;

import com.google.common.primitives.Ints;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.level.gameevent.RailcraftGameEvents;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class MultiblockListener
implements GameEventListener {
    private final MultiblockBlockEntity<?, ?> blockEntity;
    private final PositionSource positionSource;
    private final int radius;

    public MultiblockListener(MultiblockBlockEntity<?, ?> blockEntity) {
        this.blockEntity = blockEntity;
        this.positionSource = new BlockPositionSource(blockEntity.getBlockPos());
        int radius = 0;
        for (MultiblockPattern<?> pattern : blockEntity.getPatterns()) {
            radius = Math.max(radius, Ints.max((int[])new int[]{pattern.getXSize(), pattern.getYSize(), pattern.getZSize()}));
        }
        this.radius = radius;
    }

    public PositionSource getListenerSource() {
        return this.positionSource;
    }

    public int getListenerRadius() {
        return this.radius;
    }

    public boolean handleGameEvent(ServerLevel serverLevel, Holder<GameEvent> gameEvent, GameEvent.Context context, Vec3 source) {
        if (gameEvent.is(RailcraftGameEvents.NEIGHBOR_NOTIFY)) {
            this.blockEntity.enqueueEvaluation();
        }
        return false;
    }
}

