/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.RefinedFirestoneItem;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.RitualBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RitualBlock
extends BaseEntityBlock {
    public static final BooleanProperty CRACKED = BooleanProperty.create((String)"cracked");
    private static final VoxelShape SHAPE = Shapes.create((AABB)BoxBuilder.create().box().inflateHorizontally(-0.3).raiseCeiling(-0.5625).shiftY(0.75).build());
    private static final MapCodec<RitualBlock> CODEC = RitualBlock.simpleCodec(RitualBlock::new);

    public RitualBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CRACKED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CRACKED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter source, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState) {
        return RefinedFirestoneItem.getItemCharged();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof RitualBlockEntity) {
            RitualBlockEntity firestone = (RitualBlockEntity)blockEntity;
            RefinedFirestoneItem item = (Boolean)state.getValue((Property)CRACKED) != false ? (RefinedFirestoneItem)((Object)RailcraftItems.CRACKED_FIRESTONE.get()) : (RefinedFirestoneItem)((Object)RailcraftItems.REFINED_FIRESTONE.get());
            ItemStack drop = item.getDefaultInstance();
            if (firestone.hasCustomName()) {
                drop.set(DataComponents.CUSTOM_NAME, (Object)firestone.getCustomName());
            }
            drop.setDamageValue(drop.getMaxDamage() - firestone.charge());
            drops.add(drop);
        } else {
            drops.add(RefinedFirestoneItem.getItemEmpty());
        }
        return drops;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new RitualBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return RitualBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.RITUAL.get()), (BlockEntityTicker)(level.isClientSide() ? RitualBlockEntity::clientTick : RitualBlockEntity::serverTick));
    }
}

