/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractStrengthenedGlassBlock
extends TransparentBlock {
    public static final Property<Type> TYPE = EnumProperty.create((String)"type", Type.class);

    public AbstractStrengthenedGlassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)Type.SINGLE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        TOP("top"),
        CENTER("center"),
        BOTTOM("bottom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type determine(BlockPos blockPos, Level level, Block block) {
            boolean above = level.getBlockState(blockPos.above()).is(block);
            boolean below = level.getBlockState(blockPos.below()).is(block);
            if (above && below) {
                return CENTER;
            }
            if (above) {
                return BOTTOM;
            }
            if (below) {
                return TOP;
            }
            return SINGLE;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

