/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.inventory.SimpleDataSlot;
import mods.railcraft.world.inventory.slot.RollingResultSlot;
import mods.railcraft.world.inventory.slot.UnmodifiableSlot;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.level.block.entity.ManualRollingMachineBlockEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ManualRollingMachineMenu
extends RailcraftMenu {
    private final ManualRollingMachineBlockEntity blockEntity;
    private final ManualRollingMachineBlockEntity.RollingCraftingContainer craftMatrix;
    private final ResultContainer craftResult;
    private final AdvancedContainer resultSlot;

    protected ManualRollingMachineMenu(MenuType<?> type, int id, Inventory inventory, ManualRollingMachineBlockEntity blockEntity, int xs, int xy) {
        super(type, id, inventory.player, blockEntity::isStillValid);
        this.blockEntity = blockEntity;
        this.craftMatrix = blockEntity.getCraftMatrix(this);
        this.resultSlot = blockEntity.getInvResult();
        this.craftResult = new ResultContainer(this){

            public void setItem(int index, ItemStack stack) {
                super.setItem(index, stack);
                stack.set(RailcraftDataComponents.CLICK_TO_CRAFT, (Object)true);
            }
        };
        this.addSlot(new SlotRollingMachine((Container)this.craftResult, 0, xs, xy));
        this.addSlot((Slot)new RollingResultSlot(this.getPlayer(), (CraftingContainer)this.craftMatrix, (Container)this.resultSlot, 0, 124, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.addSlot(new Slot((Container)this.craftMatrix, x + y * 3, 30 + x * 18, 17 + y * 18));
            }
        }
        this.addInventorySlots(inventory);
        this.addDataSlot(new SimpleDataSlot(this.blockEntity::getProgress, this.blockEntity::setProgress));
        this.addDataSlot(new SimpleDataSlot(this.blockEntity::getProcessTime, this.blockEntity::setProcessTime));
        this.slotsChanged((Container)this.craftMatrix);
    }

    public ManualRollingMachineMenu(int id, Inventory inventory, ManualRollingMachineBlockEntity blockEntity) {
        this((MenuType)RailcraftMenuTypes.MANUAL_ROLLING_MACHINE.get(), id, inventory, blockEntity, 93, 27);
    }

    public void slotsChanged(Container container) {
        this.craftResult.setItem(0, this.blockEntity.getRecipe().map(RecipeHolder::value).map(r -> r.assemble(this.craftMatrix.asCraftInput(), (HolderLookup.Provider)this.blockEntity.level().registryAccess())).orElse(ItemStack.EMPTY));
    }

    public float rollingProgress() {
        int requiredTime = this.blockEntity.getProcessTime();
        int currentTick = this.blockEntity.getProgress();
        return Mth.clamp((float)((float)currentTick / (float)requiredTime), (float)0.0f, (float)1.0f);
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, (Container)this.craftMatrix);
        this.clearContainer(player, (Container)this.resultSlot);
    }

    private class SlotRollingMachine
    extends UnmodifiableSlot {
        SlotRollingMachine(Container contents, int id, int x, int y) {
            super(contents, id, x, y);
        }

        public void onTake(Player player, ItemStack stack) {
            super.onTake(player, stack);
            ManualRollingMachineMenu.this.blockEntity.setUseLast();
        }
    }
}

