/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.EnumSet;
import java.util.Set;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.entity.vehicle.MaintenancePatternMinecart;
import mods.railcraft.world.inventory.TrackRelayerMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.entity.track.DumpingTrackBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class TrackRelayer
extends MaintenancePatternMinecart {
    private static final int STOCK_SLOT = 0;
    private static final int REPLACE_SLOT = 1;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 1);
    private static final int EXISTING_TRACK_SLOT = 0;
    private static final Set<Direction> HORIZONTAL_DIRECTION = EnumSet.of(Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH);

    public TrackRelayer(EntityType<?> type, Level level) {
        super(type, level);
    }

    public TrackRelayer(ItemStack itemStack, double x, double y, double z, ServerLevel level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.TRACK_RELAYER.get(), x, y, z, (Level)level);
    }

    @Override
    protected Item getDropItem() {
        return (Item)RailcraftItems.TRACK_RELAYER.get();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        if (this.mode() == MaintenanceMinecart.Mode.OFF) {
            return;
        }
        this.stockItems(1, 0);
        this.replace();
    }

    private void replace() {
        BlockState blockState;
        BlockPos pos = this.blockPosition();
        if (BaseRailBlock.isRail((Level)this.level(), (BlockPos)pos.below())) {
            pos = pos.below();
        }
        if (!BaseRailBlock.isRail((BlockState)(blockState = this.level().getBlockState(pos)))) {
            return;
        }
        Block block = blockState.getBlock();
        ItemStack existingTrack = this.patternContainer.getItem(0);
        if (existingTrack.isEmpty()) {
            return;
        }
        ItemStack stockTrack = this.getItem(0);
        if (stockTrack.isEmpty()) {
            return;
        }
        boolean nextToSuspended = false;
        for (Direction direction : HORIZONTAL_DIRECTION) {
            BlockEntity blockEntity = this.level().getBlockEntity(pos.offset(direction.getNormal()));
            if (!(blockEntity instanceof DumpingTrackBlockEntity)) continue;
            nextToSuspended = true;
            break;
        }
        if (nextToSuspended) {
            return;
        }
        if (ContainerTools.isItemStackBlock(existingTrack, block)) {
            RailShape trackShape = this.removeOldTrack(pos, blockState);
            this.placeNewTrack(pos, 0, trackShape);
        }
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        ItemStack trackReplace = this.patternContainer.getItem(1);
        return ItemStack.isSameItem((ItemStack)stack, (ItemStack)trackReplace);
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new TrackRelayerMenu(id, inventory, this);
    }
}

