/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.routing;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.NeedsFuel;
import mods.railcraft.api.carts.Paintable;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Routable;
import mods.railcraft.api.carts.Train;
import mods.railcraft.util.routing.RouterBlockEntity;
import mods.railcraft.util.routing.RoutingLogicException;
import mods.railcraft.util.routing.expression.Expression;
import mods.railcraft.util.routing.expression.condition.ColorCondition;
import mods.railcraft.util.routing.expression.condition.DestCondition;
import mods.railcraft.util.routing.expression.condition.LocomotiveCondition;
import mods.railcraft.util.routing.expression.condition.NameCondition;
import mods.railcraft.util.routing.expression.condition.OwnerCondition;
import mods.railcraft.util.routing.expression.condition.RedstoneCondition;
import mods.railcraft.util.routing.expression.condition.RefuelCondition;
import mods.railcraft.util.routing.expression.condition.RiderCondition;
import mods.railcraft.util.routing.expression.condition.TypeCondition;

public record RoutingLogic(Deque<Expression> expressions) {
    public static RoutingLogic parseTable(Deque<String> data) throws RoutingLogicException {
        ArrayDeque<Expression> stack = new ArrayDeque<Expression>();
        Iterator<String> it = data.descendingIterator();
        while (it.hasNext()) {
            String line = it.next().trim();
            if (line.startsWith("//") || line.startsWith("#") || line.isEmpty()) continue;
            stack.push(RoutingLogic.parseLine(line, stack));
        }
        return new RoutingLogic(stack);
    }

    private static RollingStock getRoutableCart(RollingStock rollingStock) {
        Train train = rollingStock.train();
        if (train.size() <= 1) {
            return rollingStock;
        }
        if (rollingStock.isEnd()) {
            if (rollingStock.entity() instanceof Routable) {
                return rollingStock;
            }
            if (rollingStock.entity() instanceof Paintable) {
                return rollingStock;
            }
            if (rollingStock.entity() instanceof NeedsFuel) {
                return rollingStock;
            }
        }
        return train.front();
    }

    public boolean matches(RouterBlockEntity router, RollingStock rollingStock) {
        if (this.expressions == null) {
            return false;
        }
        RollingStock controllingCart = RoutingLogic.getRoutableCart(rollingStock);
        return this.expressions.stream().anyMatch(expression -> expression.evaluate(router, controllingCart));
    }

    private static Expression parseLine(String line, Deque<Expression> stack) throws RoutingLogicException {
        try {
            if (line.startsWith("Dest")) {
                return DestCondition.parse(line);
            }
            if (line.startsWith("Color")) {
                return ColorCondition.parse(line);
            }
            if (line.startsWith("Owner")) {
                return OwnerCondition.parse(line);
            }
            if (line.startsWith("Name")) {
                return NameCondition.parse(line);
            }
            if (line.startsWith("Type")) {
                return TypeCondition.parse(line);
            }
            if (line.startsWith("NeedsRefuel")) {
                return RefuelCondition.parse(line);
            }
            if (line.startsWith("Rider")) {
                return RiderCondition.parse(line);
            }
            if (line.startsWith("Redstone")) {
                return RedstoneCondition.parse(line);
            }
            if (line.startsWith("Loco")) {
                return LocomotiveCondition.parse(line);
            }
        }
        catch (RoutingLogicException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RoutingLogicException(Translations.RoutingTable.ERROR_MALFORMED_SYNTAX, line);
        }
        if (line.equals("TRUE")) {
            return Expression.TRUE;
        }
        if (line.equals("FALSE")) {
            return Expression.FALSE;
        }
        try {
            if (line.equals("NOT")) {
                return stack.pop().negate();
            }
            if (line.equals("AND")) {
                return stack.pop().and(stack.pop());
            }
            if (line.equals("OR")) {
                return stack.pop().or(stack.pop());
            }
            if (line.equals("IF")) {
                return stack.pop().select(stack.pop(), stack.pop());
            }
        }
        catch (NoSuchElementException ex) {
            throw new RoutingLogicException(Translations.RoutingTable.ERROR_INSUFFICIENT_OPERAND, line);
        }
        catch (ClassCastException ex) {
            throw new RoutingLogicException(Translations.RoutingTable.ERROR_INVALID_OPERAND, line);
        }
        throw new RoutingLogicException(Translations.RoutingTable.UNRECOGNIZED_KEYWORD, line);
    }
}

