/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.gui.widget;

import java.util.List;
import mods.railcraft.gui.widget.Widget;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidGaugeWidget
extends Widget {
    public final StandardTank tank;
    private FluidStack lastSyncedFluidStack = FluidStack.EMPTY;
    private int syncCounter;

    public FluidGaugeWidget(StandardTank tank, int x, int y, int u, int v, int w, int h) {
        super(x, y, u, v, w, h);
        this.tank = tank;
    }

    public List<Component> getTooltip() {
        return this.tank.getTooltip();
    }

    @Override
    public boolean requiresSync(ServerPlayer player) {
        ++this.syncCounter;
        return this.syncCounter % 16 == 0 || !this.lastSyncedFluidStack.isEmpty() && !FluidStack.matches((FluidStack)this.lastSyncedFluidStack, (FluidStack)this.tank.getFluid());
    }

    @Override
    public void writeToBuf(ServerPlayer player, RegistryFriendlyByteBuf data) {
        super.writeToBuf(player, data);
        FluidStack fluidStack = this.tank.getFluid();
        this.lastSyncedFluidStack = fluidStack.copy();
        data.writeInt(this.tank.getCapacity());
        FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)data, (Object)fluidStack);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.tank.setCapacity(data.readInt());
        this.tank.setFluid((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)data));
    }
}

