/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.Function;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.renderer.blockentity.SignalAuraRenderUtil;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import mods.railcraft.world.level.block.signal.SignalBoxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.AABB;

public abstract class AbstractSignalBoxRenderer
implements BlockEntityRenderer<AbstractSignalBoxBlockEntity> {
    private static final Map<SignalAspect, ResourceLocation> ASPECT_TEXTURE_LOCATIONS = Map.of(SignalAspect.OFF, RailcraftConstants.rl("entity/signal_box_aspect/off"), SignalAspect.RED, RailcraftConstants.rl("entity/signal_box_aspect/red"), SignalAspect.YELLOW, RailcraftConstants.rl("entity/signal_box_aspect/yellow"), SignalAspect.GREEN, RailcraftConstants.rl("entity/signal_box_aspect/green"));
    private static final ResourceLocation SIDE_TEXTURE_LOCATION = RailcraftConstants.rl("entity/signal_box/side");
    private static final ResourceLocation CONNECTED_SIDE_TEXTURE_LOCATION = RailcraftConstants.rl("entity/signal_box/connected_side");
    private static final ResourceLocation BOTTOM_TEXTURE_LOCATION = RailcraftConstants.rl("entity/signal_box/bottom");
    private final CuboidModel model = new CuboidModel(0.125f, 0.0f, 0.125f, 0.875f, 0.9375f, 0.875f);

    protected abstract ResourceLocation getTopTextureLocation();

    public int getViewDistance() {
        return 512;
    }

    public void render(AbstractSignalBoxBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        SignalAuraRenderUtil.tryRenderSignalAura(blockEntity, poseStack, bufferSource);
        if (blockEntity.hasCustomName()) {
            RenderUtil.renderBlockHoverText(blockEntity.getBlockPos(), blockEntity.getCustomName(), poseStack, bufferSource, packedLight);
        }
        Function spriteGetter = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        this.model.setPackedLight(packedLight);
        this.model.setPackedOverlay(packedOverlay);
        this.model.set(Direction.UP, this.model.new CuboidModel.Face().setSprite((TextureAtlasSprite)spriteGetter.apply(this.getTopTextureLocation())).setSize(16));
        this.model.set(Direction.DOWN, this.model.new CuboidModel.Face().setSprite((TextureAtlasSprite)spriteGetter.apply(BOTTOM_TEXTURE_LOCATION)).setSize(16));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean isConnected = SignalBoxBlock.isConnected(blockEntity.getBlockState(), direction);
            this.model.set(direction, this.model.new CuboidModel.Face().setSprite((TextureAtlasSprite)spriteGetter.apply(isConnected ? CONNECTED_SIDE_TEXTURE_LOCATION : SIDE_TEXTURE_LOCATION)).setSize(16));
        }
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        CuboidModelRenderer.render(this.model, poseStack, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (SignalBoxBlock.isConnected(blockEntity.getBlockState(), direction)) {
                this.model.disable(direction);
                continue;
            }
            SignalAspect aspect = blockEntity.getSignalAspect(direction).getDisplayAspect();
            int skyLight = LightTexture.sky((int)packedLight);
            int facePackedLight = LightTexture.pack((int)aspect.getLampLight(), (int)skyLight);
            this.model.set(direction, this.model.new CuboidModel.Face().setSprite((TextureAtlasSprite)spriteGetter.apply(ASPECT_TEXTURE_LOCATIONS.get((Object)aspect))).setSize(16).setPackedLight(facePackedLight).setPackedOverlay(packedOverlay));
        }
        CuboidModelRenderer.render(this.model, poseStack, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
    }

    public AABB getRenderBoundingBox(AbstractSignalBoxBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 2), (double)(pos.getZ() + 2));
    }
}

