/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.tweaks;

import com.blakebr0.cucumber.event.ScytheHarvestCropEvent;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.pickletweaks.config.ModConfigs;
import com.blakebr0.pickletweaks.lib.ModTooltips;
import com.blakebr0.pickletweaks.util.BlacklistUtils;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public final class TweakToolUselessifier {
    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        if (TweakToolUselessifier.isUselessTool(stack.getItem())) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        if (!source.getMsgId().equals("player")) {
            return;
        }
        Entity trueSource = source.getEntity();
        if (!(trueSource instanceof Player)) {
            return;
        }
        Player player = (Player)trueSource;
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        if (TweakToolUselessifier.isUselessTool(stack.getItem())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        if (TweakToolUselessifier.isUselessTool(stack.getItem())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        if (TweakToolUselessifier.isUselessTool(stack.getItem())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        if (TweakToolUselessifier.isUselessTool(stack.getItem())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onScytheHarvestCrop(ScytheHarvestCropEvent event) {
        Player player = event.getPlayer();
        if (player.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        if (TweakToolUselessifier.isUselessTool(stack.getItem())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().getItem();
        if (TweakToolUselessifier.isUselessTool(item)) {
            List tooltip = event.getToolTip();
            ListIterator<MutableComponent> lines = tooltip.listIterator();
            while (lines.hasNext()) {
                String s = Localizable.of((String)"attribute.name.generic.attackDamage").buildString();
                if (!((Component)lines.next()).getString().contains(s)) continue;
                lines.set(Component.literal((String)" 0 ").append(s).withStyle(ChatFormatting.DARK_GREEN));
            }
            if (item instanceof HoeItem) {
                tooltip.add(ModTooltips.USELESS_HOE_1.color(ChatFormatting.RED).build());
            } else if (item instanceof SwordItem) {
                tooltip.add(ModTooltips.USELESS_WEAPON_1.color(ChatFormatting.RED).build());
            } else if (item instanceof ProjectileWeaponItem) {
                tooltip.add(ModTooltips.USELESS_BOW_1.color(ChatFormatting.RED).build());
            } else {
                tooltip.add(ModTooltips.USELESS_TOOL_1.color(ChatFormatting.RED).build());
            }
            tooltip.add(ModTooltips.USELESS_TOOL_2.color(ChatFormatting.RED).build());
        }
    }

    public static boolean isUselessTool(Item item) {
        if (!BlacklistUtils.contains(item, (List)ModConfigs.USELESS_TOOLS.get())) {
            return false;
        }
        return item instanceof TieredItem || item instanceof ProjectileWeaponItem || item instanceof ShearsItem;
    }
}

