/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature;

import com.blakebr0.cucumber.helper.CropHelper;
import com.blakebr0.pickletweaks.config.ModConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public final class FeatureRightClickHarvest {
    @SubscribeEvent
    public void onRightClickCrop(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)ModConfigs.ENABLE_RIGHT_CLICK_HARVEST.get()).booleanValue()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            BlockPos pos = event.getPos();
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            Player entity = event.getEntity();
            InteractionHand hand = event.getHand();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Item seed = CropHelper.getSeedsItem((Block)crop);
                if (crop.isMaxAge(state) && seed != null) {
                    FeatureRightClickHarvest.handleDrops(state, level, pos, (ItemLike)seed);
                    entity.swing(hand, true);
                    SoundEvent sound = block.getSoundType(state, (LevelReader)level, pos, (Entity)entity).getBreakSound();
                    level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.setBlockAndUpdate(pos, crop.getStateForAge(0));
                }
            }
            if (block instanceof NetherWartBlock && (Integer)state.getValue((Property)NetherWartBlock.AGE) == 3) {
                FeatureRightClickHarvest.handleDrops(state, level, pos, (ItemLike)Items.NETHER_WART);
                entity.swing(hand, true);
                SoundEvent sound = block.getSoundType(state, (LevelReader)level, pos, (Entity)entity).getBreakSound();
                level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    private static void handleDrops(BlockState state, Level level, BlockPos pos, ItemLike seed) {
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos));
        for (ItemStack drop : drops) {
            Item item = drop.getItem();
            if (drop.isEmpty() || item != seed) continue;
            drop.shrink(1);
            break;
        }
        for (ItemStack drop : drops) {
            if (drop.isEmpty()) continue;
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
    }
}

