/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.recipes.AERecipeTypes;
import appeng.recipes.transform.TransformRecipe;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForge;

public final class LavaTransformLogic {
    private static final Set<Item> lavaCache = new HashSet<Item>();

    public static boolean canTransformInLava(ItemEntity entity) {
        return LavaTransformLogic.getLavaTransformableItems(entity.level()).contains(entity.getItem().getItem());
    }

    public static boolean allIngredientsPresent(ItemEntity entity) {
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        Level level = entity.level();
        List<Item> items = level.getEntities(null, new AABB(x - 1.0, y - 1.0, z - 1.0, x + 1.0, y + 1.0, z + 1.0)).stream().filter(e -> e instanceof ItemEntity && !e.isRemoved()).map(e -> ((ItemEntity)e).getItem().getItem()).toList();
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(AERecipeTypes.TRANSFORM)) {
            if (!((TransformRecipe)recipe.value()).circumstance.isFluidTag(FluidTags.LAVA)) continue;
            return ((TransformRecipe)recipe.value()).getIngredients().stream().noneMatch(ingredient -> {
                for (ItemStack stack : ingredient.getItems()) {
                    if (!items.contains(stack.getItem())) continue;
                    return false;
                }
                return true;
            });
        }
        return false;
    }

    private static Set<Item> getLavaTransformableItems(Level level) {
        if (lavaCache.isEmpty()) {
            for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(AERecipeTypes.TRANSFORM)) {
                if (!((TransformRecipe)recipe.value()).circumstance.isFluidTag(FluidTags.LAVA)) continue;
                for (Ingredient ingredient : ((TransformRecipe)recipe.value()).ingredients) {
                    for (ItemStack stack : ingredient.getItems()) {
                        lavaCache.add(stack.getItem());
                    }
                }
            }
        }
        return lavaCache;
    }

    static {
        NeoForge.EVENT_BUS.addListener(event -> lavaCache.clear());
        NeoForge.EVENT_BUS.addListener(event -> {
            if (event.getPlayer() == null) {
                lavaCache.clear();
            }
        });
    }
}

