/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.StorageCell;
import gripe._90.megacells.item.cell.BulkCellInventory;
import gripe._90.megacells.item.part.DecompressionModulePart;
import gripe._90.megacells.misc.DecompressionPattern;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class DecompressionService
implements IGridService,
IGridServiceProvider,
ICraftingProvider {
    private static final String TAG_PATTERN_PRIORITY = "dcp";
    private final List<IChestOrDrive> cellHosts = new ObjectArrayList();
    private final List<IPatternDetails> patterns = new ObjectArrayList();
    private final IGrid grid;
    private int installedModules;
    private final Object2LongMap<AEKey> patternOutputs = new Object2LongOpenHashMap();
    private int patternPriority;
    private boolean priorityLocked;

    public DecompressionService(IGrid grid, ICraftingService craftingService) {
        this.grid = grid;
        craftingService.addGlobalCraftingProvider((ICraftingProvider)this);
    }

    public void addNode(IGridNode node, @Nullable CompoundTag savedData) {
        Object object = node.getOwner();
        if (object instanceof IChestOrDrive) {
            IChestOrDrive cellHost = (IChestOrDrive)object;
            this.cellHosts.add(cellHost);
        }
        if (node.getOwner() instanceof DecompressionModulePart) {
            ++this.installedModules;
            if (!this.priorityLocked && savedData != null && savedData.contains(TAG_PATTERN_PRIORITY, 3)) {
                this.patternPriority = savedData.getInt(TAG_PATTERN_PRIORITY);
                this.priorityLocked = true;
            }
        }
    }

    public void saveNodeData(IGridNode node, CompoundTag savedData) {
        if (this.priorityLocked && node.getOwner() instanceof DecompressionModulePart) {
            savedData.putInt(TAG_PATTERN_PRIORITY, this.patternPriority);
        }
    }

    public void removeNode(IGridNode node) {
        Object object = node.getOwner();
        if (object instanceof IChestOrDrive) {
            IChestOrDrive cellHost = (IChestOrDrive)object;
            this.cellHosts.remove(cellHost);
        }
        if (node.getOwner() instanceof DecompressionModulePart) {
            --this.installedModules;
        }
    }

    public void onServerStartTick() {
        if (!this.patternOutputs.isEmpty()) {
            ObjectIterator it = Object2LongMaps.fastIterator(this.patternOutputs);
            while (it.hasNext()) {
                Object2LongMap.Entry output = (Object2LongMap.Entry)it.next();
                AEKey what = (AEKey)output.getKey();
                long amount = output.getLongValue();
                long inserted = this.grid.getStorageService().getInventory().insert(what, amount, Actionable.MODULATE, IActionSource.empty());
                if (inserted >= amount) {
                    it.remove();
                    continue;
                }
                if (inserted <= 0L) continue;
                this.patternOutputs.put((Object)what, amount - inserted);
            }
        }
    }

    public void onServerEndTick() {
        this.patterns.clear();
        if (this.installedModules > 0) {
            for (IChestOrDrive cellHost : this.cellHosts) {
                for (int i = 0; i < cellHost.getCellCount(); ++i) {
                    StorageCell cell = cellHost.getOriginalCellInventory(i);
                    if (!(cell instanceof BulkCellInventory)) continue;
                    BulkCellInventory bulkCell = (BulkCellInventory)cell;
                    this.patterns.addAll(bulkCell.getDecompressionPatterns());
                }
            }
            this.grid.getCraftingService().refreshGlobalCraftingProvider((ICraftingProvider)this);
        }
    }

    public List<IPatternDetails> getAvailablePatterns() {
        return this.installedModules > 0 ? this.patterns : List.of();
    }

    public int getPatternPriority() {
        return this.patternPriority;
    }

    public void setPatternPriority(int priority, IGridNode node) {
        if (node.getOwner() instanceof DecompressionModulePart) {
            this.patternPriority = priority;
            this.priorityLocked = true;
            this.grid.getCraftingService().refreshGlobalCraftingProvider((ICraftingProvider)this);
        }
    }

    public boolean pushPattern(IPatternDetails details, KeyCounter[] inputHolder) {
        if (details instanceof DecompressionPattern) {
            GenericStack output = details.getPrimaryOutput();
            this.patternOutputs.merge((Object)output.what(), output.amount(), Long::sum);
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return false;
    }
}

