/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_attributes.modifiers;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import dev.shadowsoffire.apothic_attributes.modifiers.EntityEquipmentSlot;
import dev.shadowsoffire.apothic_attributes.modifiers.EntitySlotGroup;
import dev.shadowsoffire.apothic_attributes.modifiers.EquipmentSlotCompat;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record StackAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final StackAttributeModifiers EMPTY = new StackAttributeModifiers(List.of(), true);
    private static final Codec<StackAttributeModifiers> FULL_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Entry.CODEC.listOf().fieldOf("modifiers").forGetter(StackAttributeModifiers::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(StackAttributeModifiers::showInTooltip)).apply((Applicative)inst, StackAttributeModifiers::new));
    public static final Codec<StackAttributeModifiers> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Entry.CODEC.listOf(), p_332621_ -> new StackAttributeModifiers((List<Entry>)p_332621_, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, StackAttributeModifiers> STREAM_CODEC = StreamCodec.composite((StreamCodec)Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), StackAttributeModifiers::modifiers, (StreamCodec)ByteBufCodecs.BOOL, StackAttributeModifiers::showInTooltip, StackAttributeModifiers::new);

    public StackAttributeModifiers withTooltip(boolean showInTooltip) {
        return new StackAttributeModifiers(this.modifiers, showInTooltip);
    }

    public StackAttributeModifiers withModifierAdded(Holder<Attribute> attribute, AttributeModifier modifier, EntitySlotGroup slots) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry itemattributemodifiers$entry : this.modifiers) {
            if (itemattributemodifiers$entry.matches(attribute, modifier.id())) continue;
            builder.add((Object)itemattributemodifiers$entry);
        }
        builder.add((Object)new Entry(attribute, modifier, slots));
        return new StackAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip);
    }

    public void forEach(EntitySlotGroup slots, BiConsumer<Holder<Attribute>, AttributeModifier> action) {
        for (Entry entry : this.modifiers) {
            if (!entry.slots.equals(slots)) continue;
            action.accept(entry.attribute, entry.modifier);
        }
    }

    public void forEach(Holder<EntityEquipmentSlot> slot, BiConsumer<Holder<Attribute>, AttributeModifier> action) {
        for (Entry entry : this.modifiers) {
            if (!entry.slots.test(slot)) continue;
            action.accept(entry.attribute, entry.modifier);
        }
    }

    public static StackAttributeModifiers fromVanilla(ItemAttributeModifiers modifiers) {
        Builder builder = StackAttributeModifiers.builder();
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            builder.add((Holder<Attribute>)entry.attribute(), entry.modifier(), EquipmentSlotCompat.fromVanilla(entry.slot()));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, EntitySlotGroup slots) {
        public static final Codec<Entry> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(p_348388_ -> p_348388_.group((App)Attribute.CODEC.fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)EntitySlotGroup.CODEC.optionalFieldOf("slot", (Object)ALObjects.EquipmentSlotGroups.ANY).forGetter(Entry::slots)).apply((Applicative)p_348388_, Entry::new)));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)Attribute.STREAM_CODEC, Entry::attribute, (StreamCodec)AttributeModifier.STREAM_CODEC, Entry::modifier, EntitySlotGroup.STREAM_CODEC, Entry::slots, Entry::new);

        public boolean matches(Holder<Attribute> attribute, ResourceLocation id) {
            return attribute.equals(this.attribute) && this.modifier.is(id);
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> attribute, AttributeModifier modifier, EntitySlotGroup slots) {
            this.entries.add((Object)new Entry(attribute, modifier, slots));
            return this;
        }

        public StackAttributeModifiers build() {
            return new StackAttributeModifiers((List<Entry>)this.entries.build(), true);
        }
    }
}

