/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPI;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.item.ItemEnergized;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemNetworkReader
extends ItemEnergized {
    public ItemNetworkReader(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON).stacksTo(1));
    }

    private void displayBorder(Player player, Object toDisplay, boolean brackets) {
        player.sendSystemMessage((Component)MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, "-------------", EnumColor.DARK_BLUE, brackets ? MekanismLang.GENERIC_SQUARE_BRACKET.translate(toDisplay) : toDisplay));
    }

    private void displayEndBorder(Player player) {
        this.displayBorder(player, "[=======]", false);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        if (!world.isClientSide && player != null) {
            BlockPos pos = context.getClickedPos();
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
            if (tile != null) {
                if (!player.isCreative()) {
                    long energyPerUse = MekanismConfig.gear.networkReaderEnergyUsage.get();
                    IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(context.getItemInHand(), 0);
                    if (energyContainer == null || energyContainer.extract(energyPerUse, Action.SIMULATE, AutomationType.MANUAL) < energyPerUse) {
                        return InteractionResult.FAIL;
                    }
                    energyContainer.extract(energyPerUse, Action.EXECUTE, AutomationType.MANUAL);
                }
                Direction opposite = context.getClickedFace().getOpposite();
                if (tile instanceof TileEntityTransmitter) {
                    TileEntityTransmitter transmitterTile = (TileEntityTransmitter)tile;
                    this.displayTransmitterInfo(player, world, pos, transmitterTile, opposite);
                } else {
                    IHeatHandler transfer = WorldUtils.getCapability(world, Capabilities.HEAT, pos, null, tile, opposite);
                    if (transfer != null) {
                        this.displayBorder(player, MekanismLang.MEKANISM, true);
                        this.sendTemperature(player, transfer);
                        this.displayEndBorder(player);
                    } else {
                        this.displayConnectedNetworks(player, world, pos);
                    }
                }
                return InteractionResult.CONSUME;
            }
            if (player.isShiftKeyDown() && MekanismAPI.debug) {
                this.displayBorder(player, MekanismLang.DEBUG_TITLE, true);
                for (Component component : TransmitterNetworkRegistry.toComponents()) {
                    player.sendSystemMessage((Component)TextComponentUtil.build(EnumColor.DARK_GRAY, component));
                }
                this.displayEndBorder(player);
            }
        }
        return InteractionResult.PASS;
    }

    private void displayTransmitterInfo(Player player, Level level, BlockPos pos, TileEntityTransmitter tile, Direction opposite) {
        this.displayBorder(player, MekanismLang.MEKANISM, true);
        Transmitter<?, ?, ?> transmitter = tile.getTransmitter();
        if (transmitter.hasTransmitterNetwork()) {
            Object transmitterNetwork = transmitter.getTransmitterNetwork();
            player.sendSystemMessage((Component)MekanismLang.NETWORK_READER_TRANSMITTERS.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, ((DynamicNetwork)transmitterNetwork).transmittersSize()));
            player.sendSystemMessage((Component)MekanismLang.NETWORK_READER_ACCEPTORS.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, ((DynamicNetwork)transmitterNetwork).getAcceptorCount()));
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_NEEDED, transmitterNetwork.getNeededInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_BUFFER, transmitterNetwork.getStoredInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_THROUGHPUT, transmitterNetwork.getFlowInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_CAPACITY, transmitterNetwork.getNetworkReaderCapacity());
            IHeatHandler heatHandler = WorldUtils.getCapability(level, Capabilities.HEAT, pos, null, tile, opposite);
            if (heatHandler != null) {
                this.sendTemperature(player, heatHandler);
            }
        } else {
            player.sendSystemMessage((Component)MekanismLang.NO_NETWORK.translate());
        }
        this.displayEndBorder(player);
    }

    private void displayConnectedNetworks(Player player, Level world, BlockPos pos) {
        ObjectOpenHashSet iteratedNetworks = new ObjectOpenHashSet();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        long posAsLong = pos.asLong();
        for (Direction side : EnumUtils.DIRECTIONS) {
            TileEntityTransmitter transmitterTile;
            Transmitter<?, ?, ?> transmitter;
            Object transmitterNetwork;
            mutable.setWithOffset((Vec3i)pos, side);
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, (BlockPos)mutable);
            if (!(tile instanceof TileEntityTransmitter) || !((DynamicNetwork)(transmitterNetwork = (transmitter = (transmitterTile = (TileEntityTransmitter)tile).getTransmitter()).getTransmitterNetwork())).hasAcceptor(pos) || iteratedNetworks.contains(transmitterNetwork)) continue;
            this.displayBorder(player, this.compileList(transmitter.getSupportedTransmissionTypes()), false);
            player.sendSystemMessage((Component)MekanismLang.NETWORK_READER_CONNECTED_SIDES.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, this.compileList(((DynamicNetwork)transmitterNetwork).getAcceptorDirections(posAsLong))));
            this.displayEndBorder(player);
            iteratedNetworks.add(transmitterNetwork);
        }
    }

    private void sendTemperature(Player player, IHeatHandler handler) {
        Component temp = MekanismUtils.getTemperatureDisplay(handler.getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
        player.sendSystemMessage((Component)MekanismLang.NETWORK_READER_TEMPERATURE.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, temp));
    }

    private void sendMessageIfNonNull(Player player, ILangEntry langEntry, Object toSend) {
        if (toSend != null) {
            player.sendSystemMessage((Component)langEntry.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, toSend));
        }
    }

    private <ENUM extends Enum<ENUM>> Component compileList(Set<ENUM> elements) {
        if (elements.isEmpty()) {
            return MekanismLang.GENERIC_SQUARE_BRACKET.translate("");
        }
        MutableComponent component = null;
        for (Enum element : elements) {
            if (component == null) {
                component = TextComponentUtil.build(element);
                continue;
            }
            component = MekanismLang.GENERIC_WITH_COMMA.translate(component, element);
        }
        return MekanismLang.GENERIC_SQUARE_BRACKET.translate(component);
    }
}

