/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.assemblicator;

import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.FormulaAttachment;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record RecipeFormula(CraftingInput.Positioned craftingInput, @Nullable RecipeHolder<CraftingRecipe> recipe) {
    public static final RecipeFormula EMPTY = new RecipeFormula(CraftingInput.Positioned.EMPTY, null);

    public static RecipeFormula create(Level world, FormulaAttachment attachment) {
        return RecipeFormula.create(world, MekanismUtils.getCraftingInput(3, 3, attachment.inventory(), true));
    }

    public static RecipeFormula create(Level world, List<IInventorySlot> craftingGridSlots) {
        return RecipeFormula.create(world, MekanismUtils.getCraftingInputSlots(3, 3, craftingGridSlots, true));
    }

    public static RecipeFormula create(Level world, CraftingInput.Positioned craftingInput) {
        if (craftingInput.input().isEmpty()) {
            return EMPTY;
        }
        return new RecipeFormula(craftingInput, (RecipeHolder<CraftingRecipe>)((RecipeHolder)MekanismRecipeType.getRecipeFor(RecipeType.CRAFTING, craftingInput.input(), world).orElse(null)));
    }

    public RecipeFormula withStack(Level world, int index, ItemStack stack) {
        if (this.isEmpty() && stack.isEmpty()) {
            return this;
        }
        List<ItemStack> copy = this.getCopy(false);
        ItemStack old = copy.set(index, stack);
        if (old != null && ItemStack.isSameItemSameComponents((ItemStack)old, (ItemStack)stack)) {
            return this;
        }
        return RecipeFormula.create(world, CraftingInput.ofPositioned((int)3, (int)3, copy));
    }

    public ItemStack getInputStack(int slot) {
        if (this.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int row = slot / 3;
        int column = slot % 3;
        CraftingInput input = this.craftingInput.input();
        if (row < this.craftingInput.top() || row >= this.craftingInput.top() + input.height() || column < this.craftingInput.left() || column >= this.craftingInput.left() + input.width()) {
            return ItemStack.EMPTY;
        }
        return input.getItem(column - this.craftingInput.left(), row - this.craftingInput.top());
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean valid() {
        return this.recipe != null;
    }

    public boolean matches(Level world, List<IInventorySlot> craftingGridSlots) {
        if (this.recipe == null) {
            return false;
        }
        return ((CraftingRecipe)this.recipe.value()).matches((RecipeInput)MekanismUtils.getCraftingInputSlots(3, 3, craftingGridSlots, true).input(), world);
    }

    public boolean isIngredientInPos(Level world, ItemStack stack, int i) {
        if (this.recipe == null) {
            return false;
        }
        if (stack.isEmpty()) {
            return this.getInputStack(i).isEmpty();
        }
        ItemStack lastItem = this.getInputStack(i);
        if (lastItem.isEmpty()) {
            return false;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)lastItem)) {
            return true;
        }
        List<ItemStack> dummy = this.getCopy(false);
        dummy.set(i, stack);
        return ((CraftingRecipe)this.recipe.value()).matches((RecipeInput)CraftingInput.of((int)3, (int)3, dummy), world);
    }

    public boolean isValidIngredient(Level world, ItemStack stack) {
        if (this.recipe != null) {
            for (ItemStack inputItem : this.craftingInput.input().items()) {
                if (inputItem.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)inputItem, (ItemStack)stack)) continue;
                return true;
            }
            List<ItemStack> dummy = this.getCopy(false);
            for (int i = 0; i < 9; ++i) {
                ItemStack inputItem = dummy.get(i);
                if (inputItem.isEmpty()) continue;
                dummy.set(i, stack);
                if (((CraftingRecipe)this.recipe.value()).matches((RecipeInput)CraftingInput.of((int)3, (int)3, dummy), world)) {
                    return true;
                }
                dummy.set(i, inputItem);
            }
        }
        return false;
    }

    public List<ItemStack> getCopy(boolean copyStacks) {
        NonNullList stacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        if (this.isEmpty()) {
            return stacks;
        }
        CraftingInput input = this.craftingInput.input();
        for (int row = 0; row < input.height(); ++row) {
            int shiftedRow = 3 * (this.craftingInput.top() + row);
            for (int column = 0; column < input.width(); ++column) {
                int index = shiftedRow + this.craftingInput.left() + column;
                ItemStack stack = input.getItem(column, row);
                stacks.set(index, copyStacks ? stack.copy() : stack);
            }
        }
        return stacks;
    }
}

