/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.security;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.security.OwnerObject;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class SecurityObject
extends OwnerObject
implements ISecurityObject {
    public SecurityObject(ItemStack stack) {
        super(stack);
    }

    @Override
    public SecurityMode getSecurityMode() {
        return (SecurityMode)this.stack.getOrDefault(MekanismDataComponents.SECURITY, (Object)SecurityMode.PUBLIC);
    }

    @Override
    public void setSecurityMode(SecurityMode mode) {
        SecurityMode securityMode = this.getSecurityMode();
        if (securityMode != mode) {
            if (mode == SecurityMode.PUBLIC) {
                this.stack.remove(MekanismDataComponents.SECURITY);
            } else {
                this.stack.set(MekanismDataComponents.SECURITY, (Object)mode);
            }
            this.onSecurityChanged(securityMode, mode);
        }
    }

    @Override
    public void onSecurityChanged(@NotNull SecurityMode old, @NotNull SecurityMode mode) {
    }
}

