/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.resolver.manager;

import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.ISidedStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.proxy.ProxyStrictEnergyHandler;
import mekanism.common.capabilities.resolver.manager.ICapabilityHandlerManager;
import mekanism.common.integration.energy.EnergyCompatUtils;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EnergyHandlerManager
implements ICapabilityHandlerManager<IEnergyContainer> {
    private final Map<Direction, Map<BlockCapability<?, @Nullable Direction>, Object>> cachedCapabilities;
    private final Map<BlockCapability<?, @Nullable Direction>, Object> cachedReadOnlyCapabilities;
    private final Map<Direction, IStrictEnergyHandler> handlers;
    private final ISidedStrictEnergyHandler baseHandler;
    private final boolean canHandle;
    @Nullable
    private IStrictEnergyHandler readOnlyHandler;
    @Nullable
    private final IEnergyContainerHolder holder;

    public EnergyHandlerManager(@Nullable IEnergyContainerHolder holder, ISidedStrictEnergyHandler baseHandler) {
        this.holder = holder;
        this.canHandle = this.holder != null;
        this.baseHandler = baseHandler;
        if (this.canHandle) {
            this.handlers = new EnumMap<Direction, IStrictEnergyHandler>(Direction.class);
            this.cachedCapabilities = new EnumMap(Direction.class);
            this.cachedReadOnlyCapabilities = new IdentityHashMap();
        } else {
            this.handlers = Collections.emptyMap();
            this.cachedCapabilities = Collections.emptyMap();
            this.cachedReadOnlyCapabilities = Collections.emptyMap();
        }
    }

    @Override
    public boolean canHandle() {
        return this.canHandle;
    }

    @Override
    public List<IEnergyContainer> getContainers(@Nullable Direction side) {
        return this.canHandle() ? this.holder.getEnergyContainers(side) : Collections.emptyList();
    }

    @Override
    public List<BlockCapability<?, @Nullable Direction>> getSupportedCapabilities() {
        return EnergyCompatUtils.getLoadedEnergyCapabilities();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @Nullable
    public <T> T resolve(BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side) {
        if (this.getContainers(side).isEmpty()) {
            return null;
        }
        if (side == null) {
            Object result = this.cachedReadOnlyCapabilities.get(capability);
            if (result == null) {
                if (this.readOnlyHandler == null) {
                    this.readOnlyHandler = new ProxyStrictEnergyHandler(this.baseHandler, null, this.holder);
                }
                result = EnergyCompatUtils.wrapStrictEnergyHandler(capability, this.readOnlyHandler);
                this.cachedReadOnlyCapabilities.put(capability, result);
            }
            return (T)result;
        }
        @Nullable Map cache = this.cachedCapabilities.computeIfAbsent(side, key -> new IdentityHashMap());
        Object result = cache.get(capability);
        if (result == null) {
            IStrictEnergyHandler handler = this.handlers.get(side);
            if (handler == null) {
                handler = new ProxyStrictEnergyHandler(this.baseHandler, side, this.holder);
                this.handlers.put(side, handler);
            }
            result = EnergyCompatUtils.wrapStrictEnergyHandler(capability, handler);
            cache.put(capability, result);
        }
        return (T)result;
    }

    @Override
    public void invalidate(BlockCapability<?, @Nullable Direction> capability, @Nullable Direction side) {
        if (side == null) {
            this.cachedReadOnlyCapabilities.remove(capability);
        } else {
            Map<BlockCapability<?, @Nullable Direction>, Object> cachedSide = this.cachedCapabilities.get(side);
            if (cachedSide != null) {
                cachedSide.remove(capability);
            }
        }
    }

    @Override
    public void invalidateAll() {
        this.cachedCapabilities.clear();
        this.cachedReadOnlyCapabilities.clear();
    }
}

