/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionType;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.Nullable;

public class MekanismPermissions {
    private static final List<PermissionNode<?>> NODES_TO_REGISTER = new ArrayList();
    private static final PermissionNode.PermissionResolver<Boolean> PLAYER_IS_OP = (player, uuid, context) -> player != null && player.hasPermissions(2);
    private static final PermissionNode.PermissionResolver<Boolean> ALWAYS_TRUE = (player, uuid, context) -> true;
    public static final PermissionNode<Boolean> BYPASS_SECURITY = MekanismPermissions.node("bypass_security", PermissionTypes.BOOLEAN, (player, uuid, context) -> player != null && player.server.getPlayerList().isOp(player.getGameProfile()), new PermissionDynamicContextKey[0]);
    public static final CommandPermissionNode COMMAND = new CommandPermissionNode(MekanismPermissions.node("command", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> player != null && player.hasPermissions(0), new PermissionDynamicContextKey[0]), 0);
    public static final CommandPermissionNode COMMAND_BUILD = MekanismPermissions.nodeOpCommand("build");
    public static final CommandPermissionNode COMMAND_BUILD_REMOVE = MekanismPermissions.nodeSubCommand(COMMAND_BUILD, "remove");
    public static final CommandPermissionNode COMMAND_CHUNK = MekanismPermissions.nodeOpCommand("chunk");
    public static final CommandPermissionNode COMMAND_CHUNK_CLEAR = MekanismPermissions.nodeSubCommand(COMMAND_CHUNK, "clear");
    public static final CommandPermissionNode COMMAND_CHUNK_FLUSH = MekanismPermissions.nodeSubCommand(COMMAND_CHUNK, "flush");
    public static final CommandPermissionNode COMMAND_CHUNK_UNWATCH = MekanismPermissions.nodeSubCommand(COMMAND_CHUNK, "unwatch");
    public static final CommandPermissionNode COMMAND_CHUNK_WATCH = MekanismPermissions.nodeSubCommand(COMMAND_CHUNK, "watch");
    public static final CommandPermissionNode COMMAND_DEBUG = MekanismPermissions.nodeOpCommand("debug");
    public static final CommandPermissionNode COMMAND_FORCE_RETROGEN = MekanismPermissions.nodeOpCommand("force_retrogen");
    public static final CommandPermissionNode COMMAND_RADIATION = MekanismPermissions.nodeOpCommand("radiation");
    public static final CommandPermissionNode COMMAND_RADIATION_ADD = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION, "add");
    public static final CommandPermissionNode COMMAND_RADIATION_ADD_ENTITY = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION, "add_entity");
    public static final CommandPermissionNode COMMAND_RADIATION_ADD_ENTITY_OTHERS = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION_ADD_ENTITY, "others");
    public static final CommandPermissionNode COMMAND_RADIATION_GET = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION, "get");
    public static final CommandPermissionNode COMMAND_RADIATION_HEAL = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION, "heal");
    public static final CommandPermissionNode COMMAND_RADIATION_HEAL_OTHERS = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION_HEAL, "others");
    public static final CommandPermissionNode COMMAND_RADIATION_REDUCE = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION, "reduce");
    public static final CommandPermissionNode COMMAND_RADIATION_REDUCE_OTHERS = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION_REDUCE, "others");
    public static final CommandPermissionNode COMMAND_RADIATION_REMOVE_ALL = MekanismPermissions.nodeSubCommand(COMMAND_RADIATION, "remove.all");
    public static final CommandPermissionNode COMMAND_TEST_RULES = MekanismPermissions.nodeOpCommand("test_rules");
    public static final CommandPermissionNode COMMAND_TP = MekanismPermissions.nodeOpCommand("tp");
    public static final CommandPermissionNode COMMAND_TP_POP = MekanismPermissions.nodeOpCommand("tp_pop");

    private static CommandPermissionNode nodeOpCommand(String nodeName) {
        PermissionNode<Boolean> node = MekanismPermissions.node("command." + nodeName, PermissionTypes.BOOLEAN, PLAYER_IS_OP, new PermissionDynamicContextKey[0]);
        return new CommandPermissionNode(node, 2);
    }

    private static CommandPermissionNode nodeSubCommand(CommandPermissionNode parent, String nodeName) {
        PermissionNode<Boolean> node = MekanismPermissions.subNode(parent.node, nodeName, ALWAYS_TRUE);
        return new CommandPermissionNode(node, parent.fallbackLevel);
    }

    private static <T> PermissionNode<T> subNode(PermissionNode<T> parent, String nodeName) {
        return MekanismPermissions.subNode(parent, nodeName, (player, uuid, context) -> MekanismPermissions.getPermission(player, uuid, parent, context));
    }

    private static <T> PermissionNode<T> subNode(PermissionNode<T> parent, String nodeName, ResultTransformer<T> defaultRestrictionIncrease) {
        return MekanismPermissions.subNode(parent, nodeName, (player, uuid, context) -> {
            Object result = MekanismPermissions.getPermission(player, uuid, parent, context);
            return defaultRestrictionIncrease.transform(player, uuid, result, context);
        });
    }

    private static <T> PermissionNode<T> subNode(PermissionNode<T> parent, String nodeName, PermissionNode.PermissionResolver<T> defaultResolver) {
        String fullParentName = parent.getNodeName();
        String parentName = fullParentName.substring(fullParentName.indexOf(46) + 1);
        return MekanismPermissions.node(parentName + "." + nodeName, parent.getType(), defaultResolver, new PermissionDynamicContextKey[0]);
    }

    @SafeVarargs
    private static <T> PermissionNode<T> node(String nodeName, PermissionType<T> type, PermissionNode.PermissionResolver<T> defaultResolver, PermissionDynamicContextKey<T> ... dynamics) {
        PermissionNode node = new PermissionNode("mekanism", nodeName, type, defaultResolver, dynamics);
        NODES_TO_REGISTER.add(node);
        return node;
    }

    public static void registerPermissionNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(NODES_TO_REGISTER);
    }

    private static <T> T getPermission(@Nullable ServerPlayer player, UUID playerUUID, PermissionNode<T> node, PermissionDynamicContext<?> ... context) {
        if (player == null) {
            return (T)PermissionAPI.getOfflinePermission((UUID)playerUUID, node, context);
        }
        return (T)PermissionAPI.getPermission((ServerPlayer)player, node, context);
    }

    public record CommandPermissionNode(PermissionNode<Boolean> node, int fallbackLevel) implements Predicate<CommandSourceStack>
    {
        @Override
        public boolean test(CommandSourceStack source) {
            ServerPlayer player;
            CommandSource commandSource;
            return source.hasPermission(this.fallbackLevel) || (commandSource = source.source) instanceof ServerPlayer && (Boolean)PermissionAPI.getPermission((ServerPlayer)(player = (ServerPlayer)commandSource), this.node, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false;
        }
    }

    @FunctionalInterface
    private static interface ResultTransformer<T> {
        public T transform(@Nullable ServerPlayer var1, UUID var2, T var3, PermissionDynamicContext<?> ... var4);
    }
}

