/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.client.gui.GuiUtils;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.NotNull;

public class MekanismStatusOverlay
implements LayeredDraw.Layer {
    public static final MekanismStatusOverlay INSTANCE = new MekanismStatusOverlay();
    private static final int BASE_TIMER = 100;
    private int modeSwitchTimer = 0;
    private int lastTick;

    private MekanismStatusOverlay() {
    }

    public void setTimer() {
        this.modeSwitchTimer = 100;
    }

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker delta) {
        Minecraft minecraft = Minecraft.getInstance();
        if (this.modeSwitchTimer > 1 && minecraft.player != null && minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR && !minecraft.options.hideGui) {
            Component scrollTextComponent;
            ItemStack stack = minecraft.player.getMainHandItem();
            if (IModeItem.isModeItem(stack, EquipmentSlot.MAINHAND) && (scrollTextComponent = ((IModeItem)stack.getItem()).getScrollTextComponent(stack)) != null) {
                Color color = Color.rgbad(1.0, 1.0, 1.0, (float)this.modeSwitchTimer / 100.0f);
                Font font = minecraft.gui.getFont();
                int componentWidth = font.width((FormattedText)scrollTextComponent);
                int targetShift = Math.max(59, Math.max(minecraft.gui.leftHeight, minecraft.gui.rightHeight));
                if (minecraft.gameMode != null && !minecraft.gameMode.canHurtPlayer()) {
                    targetShift -= 14;
                } else if (minecraft.gui.overlayMessageTime > 0) {
                    targetShift += 14;
                }
                PoseStack pose = graphics.pose();
                pose.pushPose();
                pose.translate((float)(graphics.guiWidth() - componentWidth) / 2.0f, (float)(graphics.guiHeight() - (targetShift += 13)), 0.0f);
                GuiUtils.drawBackdrop(graphics, minecraft, 0, 0, componentWidth, color.a());
                graphics.drawString(font, scrollTextComponent, 0, 0, color.argb());
                pose.popPose();
            }
            if (this.lastTick != minecraft.gui.getGuiTicks()) {
                this.lastTick = minecraft.gui.getGuiTicks();
                --this.modeSwitchTimer;
            }
        }
    }
}

