/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.transfer;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.recipe_viewer.QIOCraftingTransferHandler;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class EmiQIOCraftingTransferHandler<CONTAINER extends QIOItemViewerContainer>
implements EmiRecipeHandler<CONTAINER> {
    public EmiPlayerInventory getInventory(AbstractContainerScreen<CONTAINER> screen) {
        return new EmiPlayerInventory(Collections.emptyList());
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree()) {
            RecipeHolder backingRecipe = recipe.getBackingRecipe();
            return backingRecipe != null && backingRecipe.value() instanceof CraftingRecipe;
        }
        return false;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<CONTAINER> context) {
        EmiRecipeInfo recipeInfo = EmiRecipeInfo.create(recipe, context);
        return recipeInfo != null && QIOCraftingTransferHandler.transferRecipe(recipeInfo, Action.SIMULATE) == null;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<CONTAINER> context) {
        EmiRecipeInfo recipeInfo = EmiRecipeInfo.create(recipe, context);
        if (recipeInfo != null && QIOCraftingTransferHandler.transferRecipe(recipeInfo, Action.EXECUTE) == null) {
            Minecraft.getInstance().setScreen((Screen)context.getScreen());
            return true;
        }
        return false;
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<CONTAINER> context) {
        TransferResult transferResult;
        EmiRecipeInfo recipeInfo = EmiRecipeInfo.create(recipe, context);
        if (recipeInfo != null && (transferResult = QIOCraftingTransferHandler.transferRecipe(recipeInfo, Action.SIMULATE)) != null && transferResult.tooltip() != null) {
            return List.of(EmiTooltipComponents.of((Component)transferResult.tooltip()));
        }
        return Collections.emptyList();
    }

    public void render(EmiRecipe recipe, EmiCraftContext<CONTAINER> context, List<Widget> widgets, GuiGraphics graphics) {
        TransferResult transferResult;
        EmiRecipeInfo recipeInfo = EmiRecipeInfo.create(recipe, context);
        if (recipeInfo != null && (transferResult = QIOCraftingTransferHandler.transferRecipe(recipeInfo, Action.SIMULATE)) != null && transferResult.missingSlots() != null) {
            RenderSystem.enableDepthTest();
            Object2IntOpenHashMap missingIngredients = new Object2IntOpenHashMap(transferResult.missingSlots().size());
            for (EmiRecipeSlot missingSlot : transferResult.missingSlots()) {
                missingIngredients.mergeInt((Object)missingSlot.ingredient(), 1, Integer::sum);
            }
            for (Widget w : widgets) {
                int numberMissing;
                EmiIngredient stack;
                SlotWidget sw;
                if (!(w instanceof SlotWidget) || (sw = (SlotWidget)w).getRecipe() != null || (stack = sw.getStack()).isEmpty() || (numberMissing = missingIngredients.getOrDefault((Object)stack, 0)) <= 0) continue;
                Bounds bounds = sw.getBounds();
                graphics.fill(bounds.x(), bounds.y(), bounds.right(), bounds.bottom(), 0x44FF0000);
                if (numberMissing == 1) {
                    missingIngredients.removeInt((Object)stack);
                    continue;
                }
                missingIngredients.put((Object)stack, numberMissing - 1);
            }
        }
    }

    private record EmiRecipeInfo(EmiCraftContext<? extends QIOItemViewerContainer> context, RecipeHolder<CraftingRecipe> recipeHolder, List<EmiRecipeSlot> inputs) implements QIOCraftingTransferHandler.RVRecipeInfo<TransferResult, EmiRecipeSlot, EmiStack>
    {
        @Nullable
        private static EmiRecipeInfo create(EmiRecipe recipe, EmiCraftContext<? extends QIOItemViewerContainer> context) {
            RecipeHolder backingRecipe = recipe.getBackingRecipe();
            if (backingRecipe == null || !(backingRecipe.value() instanceof CraftingRecipe)) {
                return null;
            }
            return new EmiRecipeInfo(context, (RecipeHolder<CraftingRecipe>)backingRecipe, recipe.getInputs().stream().map(EmiRecipeSlot::new).toList());
        }

        @Override
        public QIOItemViewerContainer container() {
            return (QIOItemViewerContainer)this.context.getScreenHandler();
        }

        @Override
        public int transferAmount() {
            return this.context.getAmount();
        }

        @Override
        public TransferResult createInternalError() {
            return TransferResult.INTERNAL_ERROR;
        }

        @Override
        public TransferResult createNoRoomError() {
            return new TransferResult((Component)MekanismLang.RECIPE_VIEWER_INVENTORY_FULL.translate(), null);
        }

        @Override
        public TransferResult createMissingSlotsError(List<EmiRecipeSlot> missing) {
            return new TransferResult(EmiRecipeHandler.NOT_ENOUGH_INGREDIENTS, missing);
        }

        @Override
        public Player player() {
            return Minecraft.getInstance().player;
        }

        @Override
        public EmiStack itemUUID(HashedItem hashed) {
            return EmiStack.of((ItemStack)hashed.getInternalStack(), (long)1L);
        }
    }

    private record TransferResult(@Nullable Component tooltip, @Nullable List<EmiRecipeSlot> missingSlots) {
        private static final TransferResult INTERNAL_ERROR = new TransferResult(null, null);
    }

    private record EmiRecipeSlot(EmiIngredient ingredient, List<ItemStack> itemStacks) implements QIOCraftingTransferHandler.RVRecipeSlot
    {
        private EmiRecipeSlot(EmiIngredient ingredient) {
            this(ingredient, ingredient.getEmiStacks().stream().map(EmiStack::getItemStack).filter(stack -> !stack.isEmpty()).toList());
        }

        @Override
        public ItemStack displayedIngredient() {
            if (this.itemStacks.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return this.itemStacks.getFirst();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.ingredient.equals((Object)((EmiRecipeSlot)o).ingredient);
        }

        @Override
        public int hashCode() {
            return this.ingredient.hashCode();
        }
    }
}

