/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerIngredientHelper;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;

public class GuiElementHandler {
    private static boolean areaSticksOut(int x, int y, int width, int height, int parentX, int parentY, int parentWidth, int parentHeight) {
        return x < parentX || y < parentY || x + width > parentX + parentWidth || y + height > parentY + parentHeight;
    }

    public static List<Rect2i> getAreasFor(int parentX, int parentY, int parentWidth, int parentHeight, Collection<? extends GuiEventListener> children) {
        ArrayList<Rect2i> areas = new ArrayList<Rect2i>();
        for (GuiEventListener guiEventListener : children) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            if (!widget.visible) continue;
            if (GuiElementHandler.areaSticksOut(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight(), parentX, parentY, parentWidth, parentHeight)) {
                areas.add(new Rect2i(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight()));
            }
            if (!(widget instanceof ContainerEventHandler)) continue;
            ContainerEventHandler eventHandler = (ContainerEventHandler)widget;
            for (Rect2i grandChildArea : GuiElementHandler.getAreasFor(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight(), eventHandler.children())) {
                if (!GuiElementHandler.areaSticksOut(grandChildArea.getX(), grandChildArea.getY(), grandChildArea.getWidth(), grandChildArea.getHeight(), parentX, parentY, parentWidth, parentHeight)) continue;
                areas.add(grandChildArea);
            }
        }
        return areas;
    }

    public static List<Rect2i> getGuiExtraAreas(GuiMekanism<?> gui) {
        int parentX = gui.getGuiLeft();
        int parentY = gui.getGuiTop();
        int parentWidth = gui.getXSize();
        int parentHeight = gui.getYSize();
        List<Rect2i> extraAreas = GuiElementHandler.getAreasFor(parentX, parentY, parentWidth, parentHeight, gui.children());
        extraAreas.addAll(GuiElementHandler.getAreasFor(parentX, parentY, parentWidth, parentHeight, gui.getWindows()));
        return extraAreas;
    }

    public static <INGREDIENT> Optional<INGREDIENT> getClickableIngredientUnderMouse(GuiMekanism<?> gui, double mouseX, double mouseY, BiFunction<IRecipeViewerIngredientHelper, Object, INGREDIENT> ingredientWrapper) {
        GuiElement element;
        GuiEventListener focused = gui.getFocused();
        if (focused instanceof GuiTextField || focused instanceof EditBox) {
            return Optional.empty();
        }
        if (focused instanceof GuiElement && (element = (GuiElement)focused).getFocused() instanceof GuiTextField) {
            return Optional.empty();
        }
        GuiWindow guiWindow = gui.getWindowHovering(mouseX, mouseY);
        return GuiElementHandler.getIngredientUnderMouse(guiWindow == null ? gui.children() : guiWindow.children(), mouseX, mouseY, ingredientWrapper);
    }

    private static <INGREDIENT> Optional<INGREDIENT> getIngredientUnderMouse(List<? extends GuiEventListener> children, double mouseX, double mouseY, BiFunction<IRecipeViewerIngredientHelper, Object, INGREDIENT> ingredientWrapper) {
        for (GuiEventListener guiEventListener : children) {
            if (guiEventListener instanceof AbstractWidget) {
                ContainerEventHandler eventHandler;
                Optional<INGREDIENT> underGrandChild;
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                if (!widget.visible) continue;
                if (widget instanceof ContainerEventHandler && (underGrandChild = GuiElementHandler.getIngredientUnderMouse((eventHandler = (ContainerEventHandler)widget).children(), mouseX, mouseY, ingredientWrapper)).isPresent()) {
                    return underGrandChild;
                }
            }
            if (!(guiEventListener instanceof IRecipeViewerIngredientHelper)) continue;
            IRecipeViewerIngredientHelper helper = (IRecipeViewerIngredientHelper)guiEventListener;
            if (!guiEventListener.isMouseOver(mouseX, mouseY)) continue;
            Optional<?> ingredient = helper.getIngredient(mouseX, mouseY);
            if (ingredient.isPresent()) {
                return Optional.ofNullable(ingredientWrapper.apply(helper, ingredient.get()));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

