/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiTankGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.to_server.PacketDropperUse;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GuiChemicalGauge
extends GuiTankGauge<ChemicalStack, IChemicalTank> {
    protected Component label;

    public static GuiChemicalGauge getDummy(GaugeType type, IGuiWrapper gui, int x, int y) {
        GuiChemicalGauge gauge = new GuiChemicalGauge(null, type, gui, x, y, type.getGaugeOverlay().getWidth() + 2, type.getGaugeOverlay().getHeight() + 2);
        gauge.dummy = true;
        return gauge;
    }

    public GuiChemicalGauge(GuiTankGauge.ITankInfoHandler<IChemicalTank> handler, GaugeType type, IGuiWrapper gui, int x, int y, int sizeX, int sizeY) {
        super(type, gui, x, y, sizeX, sizeY, handler, PacketDropperUse.TankType.CHEMICAL_TANK);
        this.setDummyType(ChemicalStack.EMPTY);
    }

    public GuiChemicalGauge(Supplier<IChemicalTank> tankSupplier, Supplier<List<IChemicalTank>> tanksSupplier, GaugeType type, IGuiWrapper gui, int x, int y) {
        this(tankSupplier, tanksSupplier, type, gui, x, y, type.getGaugeOverlay().getWidth() + 2, type.getGaugeOverlay().getHeight() + 2);
    }

    public GuiChemicalGauge(final Supplier<IChemicalTank> tankSupplier, final Supplier<List<IChemicalTank>> tanksSupplier, GaugeType type, IGuiWrapper gui, int x, int y, int sizeX, int sizeY) {
        this(new GuiTankGauge.ITankInfoHandler<IChemicalTank>(){

            @Override
            public IChemicalTank getTank() {
                return (IChemicalTank)tankSupplier.get();
            }

            @Override
            public int getTankIndex() {
                IChemicalTank tank = this.getTank();
                return tank == null ? -1 : ((List)tanksSupplier.get()).indexOf(tank);
            }
        }, type, gui, x, y, sizeX, sizeY);
    }

    public GuiChemicalGauge setLabel(Component label) {
        this.label = label;
        return this;
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        IChemicalTank tank = (IChemicalTank)this.getTank();
        if (tank == null || tank.isEmpty() || tank.getCapacity() == 0L) {
            return 0;
        }
        double scale = (double)tank.getStored() / (double)tank.getCapacity();
        return MathUtils.clampToInt(Math.max(1L, Math.round(scale * (double)(this.height - 2))));
    }

    @Override
    @Nullable
    public TextureAtlasSprite getIcon() {
        ChemicalStack stack = this.getStackOrDummy();
        return stack.isEmpty() ? null : MekanismRenderer.getChemicalTexture(stack);
    }

    @Override
    public Component getLabel() {
        return this.label;
    }

    private ChemicalStack getStackOrDummy() {
        if (this.dummy) {
            return (ChemicalStack)this.dummyType;
        }
        IChemicalTank tank = (IChemicalTank)this.getTank();
        return tank == null ? (ChemicalStack)this.dummyType : tank.getStack();
    }

    @Override
    public List<Component> getTooltipText() {
        ChemicalStack stack = this.getStackOrDummy();
        if (stack.isEmpty()) {
            return Collections.singletonList(MekanismLang.EMPTY.translate());
        }
        ArrayList<Component> list = new ArrayList<Component>();
        long amount = stack.getAmount();
        if (amount == Long.MAX_VALUE) {
            list.add((Component)MekanismLang.GENERIC_STORED.translate(stack, MekanismLang.INFINITE));
        } else {
            list.add((Component)MekanismLang.GENERIC_STORED_MB.translate(stack, TextUtils.format(amount)));
        }
        stack.appendHoverText(Item.TooltipContext.of((Level)GuiChemicalGauge.minecraft.level), list, (TooltipFlag)(GuiChemicalGauge.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        return list;
    }

    @Override
    protected void applyRenderColor(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, this.getStackOrDummy());
    }

    @Override
    public Optional<?> getIngredient(double mouseX, double mouseY) {
        return ((IChemicalTank)this.getTank()).isEmpty() ? Optional.empty() : Optional.of(((IChemicalTank)this.getTank()).getStack());
    }

    @Override
    public Rect2i getIngredientBounds(double mouseX, double mouseY) {
        return new Rect2i(this.getX() + 1, this.getY() + 1, this.width - 2, this.height - 2);
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.CHEMICAL;
    }
}

