/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageSetGhostSlots(Map<Integer, ItemStack> stacksToSet) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageSetGhostSlots> ID = IMessage.createType("set_ghost_slot");
    private static final StreamCodec<RegistryFriendlyByteBuf, Map<Integer, ItemStack>> MAP_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.INT, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetGhostSlots> CODEC = MAP_CODEC.map(MessageSetGhostSlots::new, MessageSetGhostSlots::stacksToSet);

    @Override
    public void process(IPayloadContext context) {
        Player player = context.player();
        context.enqueueWork(() -> {
            AbstractContainerMenu container = player.containerMenu;
            for (Map.Entry<Integer, ItemStack> e : this.stacksToSet.entrySet()) {
                int slot = e.getKey();
                if (slot < 0 || slot >= container.slots.size()) continue;
                Slot target = (Slot)container.slots.get(slot);
                if (!(target instanceof IESlot.ItemHandlerGhost)) {
                    IELogger.error("Player " + String.valueOf(player.getDisplayName()) + " tried to set the contents of a non-ghost slot.This is either a bug in IE or an attempt at cheating.");
                    return;
                }
                container.setItem(slot, container.getStateId(), e.getValue());
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

