/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.CrateItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageIncognitoSync(int entityID, boolean isIncognito) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageIncognitoSync> ID = IMessage.createType("incognito_sync");
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageIncognitoSync> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, MessageIncognitoSync::entityID, (StreamCodec)ByteBufCodecs.BOOL, MessageIncognitoSync::isIncognito, MessageIncognitoSync::new);

    @Override
    public void process(IPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Level world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null) {
                    if (this.isIncognito) {
                        CrateItem.incognitoPlayers.add(this.entityID);
                    } else {
                        CrateItem.incognitoPlayers.remove(this.entityID);
                    }
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

